% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_color}
\alias{GC_color}
\title{Update Color Scheme in Gene Chart}
\usage{
GC_color(GC_chart, colorScheme = NULL, customColors = NULL)
}
\arguments{
\item{GC_chart}{The gene chart object to be modified.}

\item{colorScheme}{Optional; character or NULL, the name of a predefined
color scheme to apply to the genes.Acceptable values include D3.js's built-in
color schemes like "schemeCategory10", "schemeAccent", "schemeTableau10".}

\item{customColors}{Either NULL, a list of color values, or a named list of
color values.}
}
\value{
Returns the gene chart object with updated color settings for the genes.
}
\description{
This function updates the color scheme of the legend and genes in a gene chart.
}
\examples{
genes_data <- data.frame(
  start = c(10, 50, 90, 130, 170, 210),
  end = c(40, 80, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 1, 2, 2, 2)
)

GC_chart(genes_data, cluster = "cluster", group = "group", height = "100px") \%>\%
  GC_color(colorScheme = "schemeCategory10")

GC_chart(genes_data, cluster = "cluster", group = "group", height = "100px") \%>\%
  GC_color(customColors = c("red", "orange", "green"))

GC_chart(genes_data, cluster = "cluster", group = "group", height = "100px") \%>\%
  GC_color(customColors = list(A = "yellow", B = "pink", C =  "purple"))


}
