rcompound <-
function(n, dist="exp", comp1=as.null(), comp2=as.null(), gamma=1, beta=1, theta1=1, theta2=1)
{
if(!any(dist == c("exp","gamma","lnorm","paretoII","bisa","lomax","beta","kumar","norm","logis","cauchy","gumbel"))) stop("distribution is not recognized")
if(!any(comp1 == c("EXP","EXP2","MO","MO2","SB")) & !is.null(comp1)) stop("distribution is not recognized")
if(!any(comp2 == c("EXP","EXP2","MO","MO2","SB")) & !is.null(comp2)) stop("distribution is not recognized")
if (is.null(n)) stop("sample size must be specified")
if (round(n) != n | n <= 0) stop("sample size must be a positive integer")
if (beta<=0) stop("beta should be positive")
if(any(dist==c("gamma","paretoII","bisa","lomax","beta","kumar")) & gamma<=0) stop("gamma should be positive")
if(any(comp1 == c("EXP","EXP2","MO","MO2")) & theta1<=0) stop("theta1 should be positive")
if(any(comp2 == c("EXP","EXP2","MO","MO2")) & theta2<=0) stop("theta2 should be positive")
if(!is.null(comp1)){if(comp1=="SB" & (theta1< -1 | theta1> 1)) stop("theta1 should be between -1 and 1")}
if(!is.null(comp2)){if(comp2=="SB" & (theta2< -1 | theta2> 1)) stop("theta2 should be between -1 and 1")}
F=get(paste("q",dist,sep=""))
if(!is.null(comp2)){G2=get(paste("q",comp2,sep=""))}
if(!is.null(comp1)){G1=get(paste("q",comp1,sep=""))}
if(dist=="exp")
{
if(!is.null(comp2)) x=F(G1(G2(runif(n),theta2),theta1),gamma)
if(is.null(comp2) & !is.null(comp1)) x=F(G1(runif(n),theta1),gamma)
if(is.null(comp2) & is.null(comp1)) x=F(runif(n),gamma)
}
if(dist!="exp")
{
if(!is.null(comp2)) x=F(G1(G2(runif(n),theta2),theta1),gamma,beta)
if(is.null(comp2) & !is.null(comp1)) x=F(G1(runif(n),theta1),gamma,beta)
if(is.null(comp2) & is.null(comp1)) x=F(runif(n),gamma,beta)
}
x
}
