% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoflow_dimension.R
\docType{class}
\name{geoflow_dimension}
\alias{geoflow_dimension}
\title{Geoflow dimension class}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling a dimension
}
\description{
This class models a dimension
}
\details{
geoflow_dimension
}
\examples{
 \dontrun{
  dimension <- geoflow_dimension$new()
  dimension$setLongName("longname")
  dimension$setResolution(uom="s",value=1)
  dimension$setSize(10)
  dimension$setValues(c(1,2,3))
  dimension$setMinValue(1)
  dimension$setMaxValue(3)
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{dimension}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{longName}}{dimension longName}

\item{\code{resolution}}{dimension resolution}

\item{\code{size}}{dimension size}

\item{\code{values}}{dimension values}

\item{\code{minValue}}{dimension min value}

\item{\code{maxValue}}{dimension max value}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-geoflow_dimension-new}{\code{geoflow_dimension$new()}}
\item \href{#method-geoflow_dimension-setLongName}{\code{geoflow_dimension$setLongName()}}
\item \href{#method-geoflow_dimension-setResolution}{\code{geoflow_dimension$setResolution()}}
\item \href{#method-geoflow_dimension-setSize}{\code{geoflow_dimension$setSize()}}
\item \href{#method-geoflow_dimension-setValues}{\code{geoflow_dimension$setValues()}}
\item \href{#method-geoflow_dimension-setMinValue}{\code{geoflow_dimension$setMinValue()}}
\item \href{#method-geoflow_dimension-setMaxValue}{\code{geoflow_dimension$setMaxValue()}}
\item \href{#method-geoflow_dimension-clone}{\code{geoflow_dimension$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_dimension-new"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_dimension-new}{}}}
\subsection{Method \code{new()}}{
Initializes the \link{geoflow_dimension}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_dimension$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_dimension-setLongName"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_dimension-setLongName}{}}}
\subsection{Method \code{setLongName()}}{
Sets the dimension long name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_dimension$setLongName(longName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{longName}}{dimension long name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_dimension-setResolution"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_dimension-setResolution}{}}}
\subsection{Method \code{setResolution()}}{
Sets the resolution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_dimension$setResolution(uom, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uom}}{unit of measure}

\item{\code{value}}{resolution value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_dimension-setSize"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_dimension-setSize}{}}}
\subsection{Method \code{setSize()}}{
Sets the dimension size
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_dimension$setSize(size)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{size}}{dimension size}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_dimension-setValues"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_dimension-setValues}{}}}
\subsection{Method \code{setValues()}}{
Sets dimension values
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_dimension$setValues(values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{dimension values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_dimension-setMinValue"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_dimension-setMinValue}{}}}
\subsection{Method \code{setMinValue()}}{
Sets dimension min value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_dimension$setMinValue(minValue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minValue}}{min value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_dimension-setMaxValue"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_dimension-setMaxValue}{}}}
\subsection{Method \code{setMaxValue()}}{
Sets dimension max value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_dimension$setMaxValue(maxValue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{maxValue}}{max value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-geoflow_dimension-clone"></a>}}
\if{latex}{\out{\hypertarget{method-geoflow_dimension-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{geoflow_dimension$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
