% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dra.R
\name{dra2r}
\alias{dra2r}
\title{DRA to R}
\usage{
dra2r(dra, state, precincts, epsg = 3857)
}
\arguments{
\item{dra}{The path to an exported csv or
a dataframe with columns GEOID20 and District, loaded from a DRA export.}

\item{state}{the state postal code of the state}

\item{precincts}{an sf dataframe of precinct shapes to link the output to}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
sf dataframe either at the block level or precinct level
}
\description{
Creates a block or precinct level dataset from DRA csv output.
}
\examples{
\dontrun{
# Needs Census Bureau API
# dra_utah_test is available at https://bit.ly/3c6UDKk
blocklevel <- dra2r('dra_utah_test.csv', state = 'UT')
}
}
\concept{dra}
