% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dra_vtd.R
\name{get_dra}
\alias{get_dra}
\title{Get Dave's Redistricting App Dataset}
\usage{
get_dra(state, year = 2020, geometry = TRUE, clean_names = TRUE, epsg = 3857)
}
\arguments{
\item{state}{two letter state abbreviation}

\item{year}{year to get data for. Either \code{2020} or \code{2010}}

\item{geometry}{Default is TRUE. Add geometry to the data?}

\item{clean_names}{Clean names. Default is \code{TRUE}. If \code{FALSE},
returns default names.}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
tibble with election data and optional geometry
}
\description{
Gets a dataset from Dave's Redistricting App.
}
\details{
See the full available data at \url{https://github.com/dra2020/vtd_data}.
}
\examples{
ak <- get_dra('AK', geometry = FALSE)
}
\concept{datasets}
