% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_textdensity.R
\name{geom_textdensity}
\alias{geom_textdensity}
\alias{geom_labeldensity}
\title{Produce smoothly labelled density plots in \pkg{ggplot2}}
\usage{
geom_textdensity(
  mapping = NULL,
  data = NULL,
  stat = "density",
  position = "identity",
  ...,
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  n = 512,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_labeldensity(
  mapping = NULL,
  data = NULL,
  stat = "density",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  n = 512,
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  arrow = NULL
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer}}. These are often aesthetics, used to set an aesthetic to a fixed value, like \code{colour = "red"} or \code{size = 3}. These can also be the following text-path parameters:\describe{\item{\code{text_only}}{A \code{logical(1)} indicating whether the path part should be plotted along with the text (\code{FALSE}, the default). If \code{TRUE}, any parameters or aesthetics relating to the drawing of the path will be ignored.}\item{\code{gap}}{A \code{logical(1)} which if \code{TRUE}, breaks the path into two sections with a gap on either side of the label. If \code{FALSE}, the path is plotted as a whole. Alternatively, if \code{NA}, the path will be broken if the string has a \code{vjust} between 0 and 1, and not otherwise. The default for the label variant is \code{FALSE} and for the text variant is \code{NA}.}\item{\code{upright}}{A \code{logical(1)} which if \code{TRUE} (default), inverts any text where the majority of letters would upside down along the path, to improve legibility. If \code{FALSE}, the path decides the orientation of text.}\item{\code{halign}}{A \code{character(1)} describing how multi-line text should be justified. Can either be \code{"center"} (default), \code{"left"} or \code{"right"}.}\item{\code{offset}}{A \code{\link[grid:unit]{unit}} object of length 1 to determine the offset of the text from the path. If this is \code{NULL} (default), the \code{vjust} parameter decides the offset. If not \code{NULL}, the \code{offset} argument overrules the \code{vjust} setting.}\item{\code{parse}}{A \code{logical(1)} which if \code{TRUE}, will coerce the labels into expressions, allowing for plotmath syntax to be used.}\item{\code{straight}}{A \code{logical(1)} which if \code{TRUE}, keeps the letters of a label on a straight baseline and if \code{FALSE} (default), lets individual letters follow the curve. This might be helpful for noisy paths.}\item{\code{padding}}{A \code{\link[grid:unit]{unit}} object of length 1 to determine the padding between the text and the path when the \code{gap} parameter trims the path.}\item{\code{text_smoothing}}{a \code{numeric(1)} value between 0 and 100 that smooths the text without affecting the line portion of the geom. The default value of \code{0} means no smoothing is applied.}\item{\code{rich}}{A \code{logical(1)} whether to interpret the text as html/markdown formatted rich text. Default: \code{FALSE}. See also the rich text section of the details in \code{\link[=geom_textpath]{geom_textpath()}}.}\item{\code{remove_long}}{if TRUE, labels that are longer than their associated path will be removed.}}}

\item{bw}{The smoothing bandwidth to be used.
If numeric, the standard deviation of the smoothing kernel.
If character, a rule to choose the bandwidth, as listed in
\code{\link[stats:bandwidth]{stats::bw.nrd()}}. Note that automatic calculation of the bandwidth does
not take weights into account.}

\item{adjust}{A multiplicate bandwidth adjustment. This makes it possible
to adjust the bandwidth while still using the a bandwidth estimator.
For example, \code{adjust = 1/2} means use half of the default bandwidth.}

\item{kernel}{Kernel. See list of available kernels in \code{\link[=density]{density()}}.}

\item{n}{number of equally spaced points at which the density is to be
estimated, should be a power of two, see \code{\link[=density]{density()}} for
details}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}.}
}
\value{
A \code{Layer} ggproto object that can be added to a plot.
}
\description{
Line plots of smoothed kernel density estimates are available
in \pkg{ggplot2} via \code{\link[ggplot2:geom_density]{geom_density}}. This geom
layer simply adds a text label to each curve that follow the contour of
the density line when used as a drop-in replacement for
\code{\link[ggplot2:geom_density]{geom_density}}
}
\section{Aesthetics}{

\code{geom_textdensity()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{label}}
  \item \code{alpha}
  \item \code{angle}
  \item \code{colour}
  \item \code{family}
  \item \code{fontface}
  \item \code{group}
  \item \code{hjust}
  \item \code{linecolour}
  \item \code{lineheight}
  \item \code{linetype}
  \item \code{linewidth}
  \item \code{size}
  \item \code{spacing}
  \item \code{textcolour}
  \item \code{vjust}
}
In addition to aforementioned aesthetics, \code{geom_labeldensity()} also understands:
\itemize{
  \item \code{boxcolour}
  \item \code{boxlinetype}
  \item \code{boxlinewidth}
  \item \code{fill}
}
The \code{spacing} aesthetic allows fine control of spacing
 of text, which is called 'tracking' in typography.
The default is 0 and units are measured in 1/1000 em.
Numbers greater than zero increase the spacing,
whereas negative numbers decrease the spacing.


Learn more about setting these aesthetics 
in \code{vignette("ggplot2-specs")}.
}

\examples{
ggplot(iris, aes(Sepal.Length, label = Species, color = Species)) +
  geom_textdensity()
}
\seealso{
Other \link[=sibling_layers]{geom layers} that place text on paths.
}
