% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbrain_layer_brain.R
\name{ggbrain_layer_brain}
\alias{ggbrain_layer_brain}
\title{R6 class for a single layer of a ggbrain panel using fill geom}
\value{
a \code{ggbrain_layer_brain} R6 class with fields related to a brain visual layer (relates to \code{geom_brain})
}
\description{
R6 class for a single layer of a ggbrain panel using fill geom

R6 class for a single layer of a ggbrain panel using fill geom
}
\details{
Note that this class is exported only for power users and rarely needs to be called directly
in typical use of the package. Instead, look at \code{geom_brain()}.
}
\section{Super class}{
\code{\link[ggbrain:ggbrain_layer]{ggbrain::ggbrain_layer}} -> \code{ggbrain_layer_brain}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fill}}{controls color of the filled in pixels for non-NA (valid) voxels. Note that this
\strong{sets} the fill color, while the \code{mapping=aes(fill=<value>)} would \strong{map} the fill to a column
in the data, consistent with ggplot2 logic.}

\item{\code{mapping}}{the ggplot2 aesthetic mapping between the data columns and the display}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ggbrain_layer_brain-new}{\code{ggbrain_layer_brain$new()}}
\item \href{#method-ggbrain_layer_brain-clone}{\code{ggbrain_layer_brain$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="add_to_gg"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-add_to_gg'><code>ggbrain::ggbrain_layer$add_to_gg()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="get_data"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-get_data'><code>ggbrain::ggbrain_layer$get_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="is_empty"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-is_empty'><code>ggbrain::ggbrain_layer$is_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="plot"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-plot'><code>ggbrain::ggbrain_layer$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_breaks"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_breaks'><code>ggbrain::ggbrain_layer$set_breaks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_limits"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_limits'><code>ggbrain::ggbrain_layer$set_limits()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_neg_breaks"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_neg_breaks'><code>ggbrain::ggbrain_layer$set_neg_breaks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_neg_limits"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_neg_limits'><code>ggbrain::ggbrain_layer$set_neg_limits()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_pos_breaks"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_pos_breaks'><code>ggbrain::ggbrain_layer$set_pos_breaks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ggbrain" data-topic="ggbrain_layer" data-id="set_pos_limits"><a href='../../ggbrain/html/ggbrain_layer.html#method-ggbrain_layer-set_pos_limits'><code>ggbrain::ggbrain_layer$set_pos_limits()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer_brain-new"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer_brain-new}{}}}
\subsection{Method \code{new()}}{
create a new ggbrain_layer object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer_brain$new(
  name = NULL,
  definition = NULL,
  limits = NULL,
  breaks = integer_breaks(),
  show_legend = TRUE,
  interpolate = NULL,
  unify_scales = TRUE,
  alpha = NULL,
  mapping = ggplot2::aes(fill = value),
  fill = NULL,
  fill_scale = NULL,
  blur_edge = NULL,
  fill_holes = NULL,
  remove_specks = NULL,
  trim_threads = NULL,
  data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the name of this layer, used for referencing in layer and panel modifications}

\item{\code{definition}}{an optional character string defining the image or contrast that should be used
to lookup data from a ggbrain_slices object. This is mostly used internally by the ggbrain + syntax
to allow layers to be defined without data in advance of the plot.}

\item{\code{limits}}{if provided, sets the upper and lower bounds on the scale}

\item{\code{breaks}}{if provided, a function to draw the breaks on the color scale}

\item{\code{show_legend}}{if TRUE, show the scale on the plot legend}

\item{\code{interpolate}}{passes to geom_raster and controls whether the fill is interpolated over continuous space}

\item{\code{unify_scales}}{if TRUE, when this layer is reused across panels, unify the scales to match}

\item{\code{alpha}}{a number between 0 and 1 that sets the alpha transparency of this layer. Default: 1}

\item{\code{mapping}}{the aesthetic mapping of the layer data to the display. Should be an aes() object and supports
\code{fill} (color of filled pixels). Default is \code{aes(fill=value)}, which maps the numeric value of the layer data
to the fill color of the squares at each spatial position. For labeled data, you might use \code{aes(fill=<label_col_name>)}.}

\item{\code{fill}}{A character string indicating the color used to fill all non-NA pixels in this layer. This is used in
distinction to \code{mapping=aes(fill=<variable>)}.}

\item{\code{fill_scale}}{a ggplot scale object used for mapping the value column as the fill color for the
layer.}

\item{\code{blur_edge}}{the standard deviation (sigma) of a Gaussian kernel applied to the edge of this layer to
smooth it. This makes the layer less jagged in appearance and is akin to antialiasing.}

\item{\code{fill_holes}}{the size of holes (in pixels) inside clusters to be filled by nearest neighbor imputation prior to display}

\item{\code{remove_specks}}{the size of specks (in pixels) to be removed from each slice prior to display}

\item{\code{trim_threads}}{the minimum number of neighboring pixels (including diagonals) that must be present to keep a pixel}

\item{\code{data}}{the data.frame containing image data for this layer. Must contain "dim1", "dim2",
and "value" as columns}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
To set mapping, you must provide a ggplot2 aes() object. A geom_brain() layer requires
a \code{fill} aesthetic mapping, which controls the fill color of regions.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_layer_brain-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_layer_brain-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_layer_brain$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
