% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feats.R
\name{as_feats}
\alias{as_feats}
\title{Compute a layout for feat data}
\usage{
as_feats(x, seqs, ..., everything = TRUE)
}
\arguments{
\item{x}{feat data convertible to a feat layout}

\item{seqs}{the sequence layout the feat map onto.}

\item{...}{passed on to \code{layout_seqs()}}

\item{everything}{set to FALSE to drop optional columns}
}
\value{
a tbl_df with plot coordinates
}
\description{
Read feat data such as genes into a tidy dataframe and augment it with
layout information based on a sequence layout.
}
\details{
Obligatory columns are \code{seq_id}, \code{start} and \code{end}. Also recognized are
\code{strand} and \code{bin_id}.

Note \code{start} and \code{end} for every record will be coerced so that \code{start < end}. If no \code{strand} was provided, \code{strand} will added and set to "+" for
records that initially had \code{start < end} and "-" for \code{end < start} inputs. If
\code{strand} was provided, \code{start} and \code{end} will be ordered without any
additional effect.
}
\keyword{internal}
