% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/during.R
\name{\%during\%}
\alias{\%during\%}
\title{Is a date covered by a grouped date}
\usage{
date \%during\% x
}
\arguments{
\item{date}{A scalar \verb{<date>} object.}

\item{x}{grouped date vector.}
}
\value{
A logical vector indicating whether the date was present within the range of
the tested object.
}
\description{
\verb{\%during\%} determines whether a supplied date is within the period covered
by each element of a grates object.
}
\examples{

dates <- as.Date("2020-01-01") + 1:10
week <- as_isoweek(dates)
dates[1] \%during\% week

period <- as_period(dates, n = 3)
dates[10] \%during\% period

}
