% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/month-class.R
\name{month_class}
\alias{month_class}
\alias{as_month}
\alias{as_month.default}
\alias{as_month.Date}
\alias{as_month.POSIXt}
\alias{as_month.character}
\alias{as_month.factor}
\alias{new_month}
\alias{is_month}
\title{Month class}
\usage{
as_month(x, n, ...)

\method{as_month}{default}(x, n, ...)

\method{as_month}{Date}(x, n, ...)

\method{as_month}{POSIXt}(x, n, ...)

\method{as_month}{character}(x, n, ...)

\method{as_month}{factor}(x, n, ...)

new_month(x = integer(), n)

is_month(xx)
}
\arguments{
\item{x, xx}{\R objects.}

\item{n}{\verb{[integer]}

Number of months that are being grouped. Must be greater than 1 (use
\code{as_yearmonth()} for this case).}

\item{...}{Only used For character input where additional arguments are passed through
to \code{as.Date()}.}
}
\value{
A \verb{<grates_month>} object.
}
\description{
Month objects are groupings of 'n consecutive months' stored relative to the
Unix Epoch. More precisely, \code{grates_month} objects are stored as the integer
number (starting at 0), of n-month groups since the Unix Epoch (1970-01-01).
}
\details{
\code{as_month()} is a generic for conversion to \verb{<grates_month>}.
\itemize{
\item Character input is first parsed using \code{as.Date()}.
\item POSIXt inputs are converted with the timezone respected.
\item Precision is only to the month level (i.e. the day of the month is always
dropped).
}

\code{new_month()} is a minimal constructor for \verb{<grates_month>} objects
aimed at developers. It takes, as input \code{x}, the number of n-months since
the Unix Epoch (1970-01-01) and the related value of \code{n}.
\code{double} vectors will be converted via \code{as.integer(floor(x))}.
}
\examples{

# date coercion
as_month(Sys.Date(), n = 2)

# character coercion
as_month("2019-05-03", n = 4)

# POSIXt coercion
as_month(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"), n = 2)

# direct construction
d <- seq.Date(from = as.Date("1970-03-01"), by = "2 month", length.out = 10)
stopifnot(
    identical(
        as_month(d, n = 2),
        new_month(1:10, 2)
    )
)

}
\references{
The algorithm to convert between dates and months relative to the UNIX Epoch
comes from the work of Davis Vaughan in the
\href{https://github.com/DavisVaughan/datea/}{datea} package.
}
\seealso{
The \link[=yearmonth_class]{yearmonth} class.
}
