% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xregTransformer.R
\name{xregTransformer}
\alias{xregTransformer}
\title{Exogenous variables transformer}
\usage{
xregTransformer(xreg, functions = c("log", "exp", "inv", "sqrt", "square"),
  silent = TRUE)
}
\arguments{
\item{xreg}{Vector / matrix / data.frame, containing variables that need
to be expanded. In case of vector / matrix it is recommended to provide
\code{ts} object, so the frequency of the data is taken into account.}

\item{functions}{Vector of names for functions used.}

\item{silent}{If \code{silent=FALSE}, then the progress is printed out.
Otherwise the function won't print anything in the console.}
}
\value{
\code{ts} matrix with the transformed and the original variables
is returned.
}
\description{
Function transforms each variable in the provided matrix or vector,
producing non-linear values, depending on the selected pool of functions.
}
\details{
This function could be useful when you want to automatically select the
necessary transformations of the variables. This can be used together
with \code{xregDo="select"} in \link[smooth]{es}, \link[smooth]{ces},
\link[smooth]{gum} and \link[smooth]{ssarima}. However, this might be
dangerous, as it might lead to the overfitting the data. So be reasonable
when you produce the transformed variables.
}
\examples{
# Create matrix of two variables and expand it
x <- cbind(rnorm(100,100,1),rnorm(100,50,3))
xregTransformer(x)

}
\seealso{
\code{\link[smooth]{es}, \link[greybox]{stepwise},
\link[greybox]{xregExpander}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
