% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_hcru.R
\name{estimate_hcru}
\alias{estimate_hcru}
\title{estimate_hcru}
\usage{
estimate_hcru(
  data,
  cohort_col = "cohort",
  patient_id_col = "patient_id",
  admit_col = "admission_date",
  discharge_col = "discharge_date",
  index_col = "index_date",
  visit_col = "visit_date",
  encounter_id_col = "encounter_id",
  setting_col = "care_setting",
  cost_col = "cost_usd",
  readmission_col = "readmission",
  time_window_col = "period",
  los_col = "length_of_stay",
  custom_var_list = NULL,
  pre_days = 180,
  post_days = 365,
  readmission_days_rule = 30,
  group_var_main = "cohort",
  group_var_by = "care_setting",
  test = NULL,
  timeline = "Pre",
  gt_output = TRUE
)
}
\arguments{
\item{data}{A dataframe specifying the health care details.}

\item{cohort_col}{A character specifying the name of the cohort column.}

\item{patient_id_col}{A character specifying the name of the patient
identifier column.}

\item{admit_col}{A character specifying the name of the date of admission
column.}

\item{discharge_col}{A character specifying the name of the date of
discharge column.}

\item{index_col}{A character specifying the name of the index date or
diagnosis column.}

\item{visit_col}{A character specifying the name of the date of
visit/claim column.}

\item{encounter_id_col}{A character specifying the name of the
encounter/claim column.}

\item{setting_col}{A character specifying the name of the HCRU
setting column e.g. IP, ED, OP, etc.}

\item{cost_col}{A character specifying the name of cost column.}

\item{readmission_col}{A character specifying the name of readmission
column.}

\item{time_window_col}{A character specifying the name of time window
column.}

\item{los_col}{A character specifying the name of length of stay column.}

\item{custom_var_list}{A character vector providing the list of additional
columns.}

\item{pre_days}{Number of days before index (default 180 days).}

\item{post_days}{Number of days after index (default 365 days).}

\item{readmission_days_rule}{Rule for how many days can be permissible to
define readmission criteria in AP setting (default 30 days).}

\item{group_var_main}{A character specifying the name of the main
grouping column.}

\item{group_var_by}{A character specifying the name of the secondary
grouping column.}

\item{test}{An optional named list of statistical tests
(e.g., \code{list(age = "wilcox.test")}).}

\item{timeline}{A character specifying the timeline window (default "Pre").}

\item{gt_output}{Logical; if \code{TRUE}, also returns output formatted
using \pkg{gtsummary} (default is \code{TRUE}).}
}
\value{
A list containing one or two summary data frames:
\describe{
  \item{Summary by settings using dplyr}{A descriptive summary of HCRU
  metrics by cohort, setting, and time window.}
  \item{Summary by settings using gtsummary (optional)}{Formatted summary
  statistics using \pkg{gtsummary}, if \code{gt_output = TRUE}.}
}
}
\description{
This function calculates estimates of healthcare resource utilization (HCRU)
from electronic health record data across various care settings
(e.g., IP, OP, ED/ER). It provides descriptive summaries of patient counts,
encounters, costs, length of stay, and readmission rates for pre- and
post-index periods.
}
\examples{
\donttest{
df <- hcru_sample_data[sample(nrow(hcru_sample_data), 10), ]
estimate_hcru(data = df)
}
}
