% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdcate_main_operators.R
\name{HDCATE.inference}
\alias{HDCATE.inference}
\title{Construct uniform confidence bands}
\usage{
HDCATE.inference(
  HDCATE_model,
  sig_level = 0.01,
  n_rep_boot = 1000,
  verbose = FALSE
)
}
\arguments{
\item{HDCATE_model}{an object created via \link{HDCATE}}

\item{sig_level}{a (vector of) significant level, such as 0.01, or c(0.01, 0.05, 0.10)}

\item{n_rep_boot}{repeat n times for bootstrap, the default is 1000}

\item{verbose}{whether the verbose message is displayed, the default is \code{FALSE}}
}
\value{
None. The HDCATE confidence bands are constructed.
}
\description{
Construct uniform confidence bands
}
\examples{
# get simulation data
n_obs <- 500  # Num of observations
n_var <- 100  # Num of observed variables
n_rel_var <- 4  # Num of relevant variables
data <- HDCATE.get_sim_data(n_obs, n_var, n_rel_var)
# conditional expectation model is misspecified
x_formula <- paste(paste0('X', c(2:n_var)), collapse ='+')
# propensity score model is misspecified
# x_formula <- paste(paste0('X', c(1:(n_var-1))), collapse ='+')

# create a new HDCATE model
model <- HDCATE(data=data, y_name='Y', d_name='D', x_formula=x_formula)

HDCATE.set_condition_var(model, 'X2', min=-1, max=1, step=0.01)

\donttest{
HDCATE.fit(model)
HDCATE.inference(model)
}
}
