% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdcate_main_operators.R
\name{HDCATE.set_bw}
\alias{HDCATE.set_bw}
\title{Set bandwidth}
\usage{
HDCATE.set_bw(model, bandwidth = "default")
}
\arguments{
\item{model}{an object created via \link{HDCATE}}

\item{bandwidth}{the value of bandwidth}
}
\value{
None.
}
\description{
Set user-defined bandwidth.
}
\examples{
# get simulation data
n_obs <- 500  # Num of observations
n_var <- 100  # Num of observed variables
n_rel_var <- 4  # Num of relevant variables
data <- HDCATE.get_sim_data(n_obs, n_var, n_rel_var)
# conditional expectation model is misspecified
x_formula <- paste(paste0('X', c(2:n_var)), collapse ='+')
# propensity score model is misspecified
# x_formula <- paste(paste0('X', c(1:(n_var-1))), collapse ='+')

# create a new HDCATE model
model <- HDCATE(data=data, y_name='Y', d_name='D', x_formula=x_formula)

# Set user-defined bandwidth, e.g., 0.15.
HDCATE.set_bw(model, 0.15)
}
