% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_elements.R
\name{element_validation}
\alias{element_validation}
\alias{validate_elements}
\alias{prop_elements_valid}
\alias{count_elements_invalid}
\title{Validate HEIMS elements}
\usage{
validate_elements(DT, .progress_cat = FALSE)

prop_elements_valid(DT, char = FALSE)

count_elements_invalid(DT, char = FALSE)
}
\arguments{
\item{DT}{The data.table whose variables are to be validated.}

\item{.progress_cat}{Should the progress of the function be displayed on the console? If \code{TRUE} the name of the element about to be validated is shown.}

\item{char}{Return as character vector, in particular marking -- any complete or completely absent values.}
}
\value{
A named logical vector, whether or not the variable complies with the style requirements. A value of \code{NA} indicates the variable
was not checked (perhaps because it is absent from \code{heims_data_dict}).
}
\description{
Return TRUE or FALSE on whether or not each variable in a data.table complies with the HEIMS code limits
}
\details{
For early detection of invalid results, the type of the variable (in particular integer vs double) is considered first,
vetoing a \code{TRUE} result if different.
}
\examples{
X <- data.frame(E306 = c(0, 1011, 999, 9998))
validate_elements(X)  # FALSE
prop_elements_valid(X)
X <- data.frame(E306 = as.integer(c(0, 1011, 999, 9998)))
validate_elements(X)  # TRUE

}
