% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpackedbubble.R
\name{hpackedbubble}
\alias{hpackedbubble}
\title{Create Split Packed Bubble Charts}
\usage{
hpackedbubble(cat, name, value, theme = "sandsignika", width = NULL,
  height = NULL, title = "", titleAlign = "center",
  titleSize = "20px", titleColor = "#333333", subtitle = "",
  subtitleAlign = "center", subtitleSize = "",
  subtitleColor = "#666666",
  pointFormat = "<b>{point.name}:</b> {point.y}", split = 1,
  packedbubbleMinSize = "50\%", packedbubbleMaxSize = "250\%",
  packedbubbleZMin = 0, packedbubbleZmax = 1000,
  gravitational = 0.0625, seriesInteraction = 1,
  dragBetweenSeries = 1, parentNodeLimit = 1, dataLabels = 1,
  dataLabelsformat = "{point.name}", dataLabelsFilter = 250,
  dataLabelsColor = "black")
}
\arguments{
\item{cat}{category verctor;}

\item{name}{name vector;}

\item{value}{value vector;}

\item{theme}{chart theme, you can use these themes:
darkgreen/darkblue/avocado/darkunica/gray/
gridlight/grid/sandsignika/sunset;}

\item{width}{chart width, for example, "100\%";}

\item{height}{chart height, for example, "400px";}

\item{title}{title;}

\item{titleAlign}{title alignment, left/center/right;}

\item{titleSize}{title size, like "20px";}

\item{titleColor}{title color, like "#333333";}

\item{subtitle}{subtitle;}

\item{subtitleAlign}{subtitle alignment, left/center/right;}

\item{subtitleSize}{subtitle size, like "16px";}

\item{subtitleColor}{subtitle color, like "#666666"}

\item{pointFormat}{The HTML of the point's line in the tooltip.}

\item{split}{Whether to split series into individual groups or to mix all series together. 1 means to split, 0 means to not, defaults to split;}

\item{packedbubbleMinSize}{Minimum bubble size. Defaults to '50\%';}

\item{packedbubbleMaxSize}{Maximum bubble size. Defaults to '250\%';}

\item{packedbubbleZMin}{The minimum for the Z value range. Defaults to 0, you can use the lowest Z value in the data;}

\item{packedbubbleZmax}{The maximum for the Z value range. Defaults to 1000, you can use the highest Z value in the data;}

\item{gravitational}{Gravitational const used in the barycenter force of the algorithm. Defaults to 0.0625.}

\item{seriesInteraction}{Whether series should interact with each other or not. 1 means to true, 0 means to false, defaults to 1;}

\item{dragBetweenSeries}{In case of split series, this option allows user to drag and drop points between series, for changing point related series. 1 means to true, 0 means to false, defaults to 1;}

\item{parentNodeLimit}{Whether bubbles should interact with their parentNode to keep them inside. 1 means to true, 0 means to false, defaults to 1;}

\item{dataLabels}{Options for the series data labels, appearing next to each data point. 1 means to true, 0 means to false, defaults to 1;}

\item{dataLabelsformat}{Data labels' format}

\item{dataLabelsFilter}{Show data labels while 'value' larger than dataLabelsFilter. defaults to 250.}

\item{dataLabelsColor}{Data labels' color, defaults to black.}
}
\description{
By binding R functions and the 'Highcharts' \url{http://www.highcharts.com/} charting library, 'hpackedbubble' package provides a simple way to draw split packed bubble charts.
}
\examples{
library(hpackedbubble)
if (interactive()) {
  hpackedbubble(CO2$continent, CO2$country, CO2$CO2)
}
}
