% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f1dr.R
\name{f1dr}
\alias{f1dr}
\title{Estimate Double Reduction in F1 Populations}
\usage{
f1dr(nvec, G1, G2)
}
\arguments{
\item{nvec}{A vector containing the observed genotype counts,
where \code{nvec[[i]]} is the number of individuals with genotype
\code{i-1}. This should be of length \code{ploidy+1}.}

\item{G1}{The dosage of parent 1. Should be an integer between \code{0}
and \code{ploidy}.}

\item{G2}{The dosage of parent 2. Should be an integer between \code{0}
and \code{ploidy}.}
}
\value{
A list with some or all of the following elements:
\describe{
\item{\code{alpha}}{A vector of numerics of length
\code{floor(ploidy / 4)}, the estimated double reduction rate.}
\item{\code{llike}}{The final log-likelihood.}
}
}
\description{
Estimates double reduction in F1 populations by maximum likelihood.
}
\examples{
set.seed(1)
size <- 100
qvec <- zygdist(alpha = 0.1, G1 = 2, G2 = 2, ploidy = 4)
nvec <- c(stats::rmultinom(n = 1, size = size, prob = qvec))
f1dr(nvec = nvec, G1 = 2, G2 = 2)

}
\seealso{
\code{\link{zygdist}()} for calculating the probability of
offpring genotypes given parental genotypes and the double reduction
rate.
}
\author{
David Gerard
}
