% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/household_column_get.R
\name{household_column_get}
\alias{household_column_get}
\title{Return Final Household Expenditure}
\usage{
household_column_get(data_table)
}
\arguments{
\item{data_table}{A symmetric input-output table, a use table, or a
supply table.}
}
\value{
A tibble/data frame with the key column and the household
expenditure column. Returns \code{NULL} if no household column is found.
}
\description{
Extracts the column of final household expenditure from a
symmetric input-output table, a use table, or a supply table. If no
household expenditure column is detected, returns \code{NULL}.
}
\examples{
household_column_get(iotable_get(source = "germany_1995"))
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{empty_remove}()},
\code{\link{household_column_find}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
