% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iotable_get.R
\name{iotable_get}
\alias{iotable_get}
\title{Get a single input–output table from bulk data}
\usage{
iotable_get(
  labelled_io_data = NULL,
  source = "germany_1995",
  geo = "DE",
  year = 1990,
  unit = "MIO_EUR",
  stk_flow = "DOM",
  labelling = "iotables",
  data_directory = NULL,
  force_download = TRUE
)
}
\arguments{
\item{labelled_io_data}{Optional nested bulk data as returned by
\code{\link[=iotables_download]{iotables_download()}}. If \code{NULL} (default), data are retrieved from
cache or downloaded.}

\item{source}{Data source code (see list above).}

\item{geo}{Country code or name, e.g. \code{"SK"} or \code{"Slovakia"}.}

\item{year}{Numeric year. Defaults to \code{1990} for \code{germany_1995}.}

\item{unit}{Currency unit, usually \code{"MIO_NAC"} or \code{"MIO_EUR"}.}

\item{stk_flow}{Stock/flow: \code{"DOM"}, \code{"IMP"}, or \code{"TOTAL"}. For
margins/taxes (\code{cp1620}, \code{cp1630} and \code{pyp} variants) only \code{"TOTAL"}
is used; other inputs are coerced with a warning.}

\item{labelling}{Column naming scheme: \code{"iotables"} (default) for
consistent names; \code{"short"} for original short codes; \code{"eurostat"}
is treated as \code{"short"}.}

\item{data_directory}{Optional directory to save the processed wide
table (RDS). If \code{NULL}, nothing is saved.}

\item{force_download}{Logical. If \code{TRUE}, force a fresh download when
\code{labelled_io_data} is not supplied. Defaults to \code{TRUE}.}
}
\value{
A \strong{wide} \code{data.frame} representing the selected IO table, with a key
column followed by ordered numeric columns.
}
\description{
Filter and reshape one IO/SUT table from a bulk dataset (typically a
Eurostat download). In most workflows you will call this function
rather than \code{\link[=iotables_download]{iotables_download()}}, which it invokes as needed.
}
\details{
The Eurostat bulk tables arrive in long form and are not ordered for
matrix algebra. This function selects the requested country (\code{geo}),
year, unit and stock/flow (\code{stk_flow}), joins iotables metadata for
consistent row/column labelling, and returns a \strong{wide} table ready
for analysis.

Supported sources include:
\itemize{
\item \code{naio_10_cp1700} — symmetric IO, basic prices (prod × prod)
\item \code{naio_10_pyp1700} — previous years' prices
\item \code{naio_10_cp1750} — symmetric IO, basic prices (ind × ind)
\item \code{naio_10_pyp1750} — previous years' prices
\item \code{naio_10_cp15} — supply at basic prices incl. margins/taxes
\item \code{naio_10_cp16} — use at purchasers' prices
\item \code{naio_10_cp1610} — use at basic prices
\item \code{naio_10_cp1620} — trade & transport margins (basic prices)
\item \code{naio_10_cp1630} — taxes less subsidies on products (basic prices)
\item \verb{naio_10_pyp*} — corresponding previous years' prices variants
\item \code{germany_1995} — packaged Beutel example
\item \code{croatia_2010_1700/1800/1900} — packaged examples
\item \verb{uk_2010_*} — packaged UK 2010 variants
}
}
\examples{
germany_table <- iotable_get(
  source = "germany_1995",
  geo = "DE", year = 1990, unit = "MIO_EUR",
  labelling = "iotables"
)

}
\concept{iotables import functions}
