% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods_islasso.path.R
\name{predict.islasso.path}
\alias{predict.islasso.path}
\title{Prediction Method for islasso.path Objects}
\usage{
\method{predict}{islasso.path}(
  object,
  newdata,
  type = c("link", "response", "coefficients", "class"),
  lambda,
  ...
)
}
\arguments{
\item{object}{A fitted model object of class \code{"islasso.path"}.}

\item{newdata}{Optional data frame containing covariates for prediction.
If omitted, returns fitted values from the original model.}

\item{type}{Character. Type of prediction:
\itemize{
  \item \code{"link"} (default) - linear predictor scale,
  \item \code{"response"} - original response scale,
  \item \code{"coefficients"} - estimated coefficients,
  \item \code{"class"} - predicted class labels (only for binomial models).
}}

\item{lambda}{Numeric value(s). Specific lambda value(s) at which predictions are required.
If missing, predictions are computed for the full lambda sequence.}

\item{...}{Additional arguments passed to lower-level methods.}
}
\value{
A vector, matrix, or list depending on the \code{type} requested.
}
\description{
Generates predictions from a fitted \code{\link{islasso.path}} model at one or more lambda values.
Supports various output types including linear predictors, response scale, class labels, and coefficients.
}
\examples{
\dontrun{
  set.seed(1)
  n <- 100; p <- 30
  beta <- c(runif(10, -3, 3), rep(0, p - 10))
  sim <- simulXy(n = n, p = p, beta = beta, seed = 1, family = gaussian())
  fit <- islasso.path(y ~ ., data = sim$data, family = gaussian())
  optimal <- GoF.islasso.path(fit)
  pred <- predict(fit, type = "response", lambda = optimal$lambda.min)
}

}
\seealso{
\code{\link{islasso.path}}, \code{\link{summary.islasso.path}}, \code{\link{coef.islasso.path}},
         \code{\link{GoF.islasso.path}}, \code{\link{fitted.islasso.path}}, \code{\link{logLik.islasso.path}},
         \code{\link{residuals.islasso.path}}, \code{\link{deviance.islasso.path}}
}
\author{
Gianluca Sottile \email{gianluca.sottile@unipa.it}
}
