% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods_islasso.path.R
\name{plot.islasso.path}
\alias{plot.islasso.path}
\title{Coefficient Profile and Diagnostic Plots for islasso.path}
\usage{
\method{plot}{islasso.path}(
  x,
  yvar = c("coefficients", "se", "gradient", "weight", "gof"),
  gof = c("none", "AIC", "BIC", "AICc", "eBIC", "GCV", "GIC"),
  label = FALSE,
  legend = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"islasso.path"}, typically created via \code{\link{islasso.path}}.}

\item{yvar}{Character. Specifies what to display on the y-axis. Choices are:
\itemize{
  \item \code{"coefficients"} - coefficient paths over \code{log(lambda)},
  \item \code{"se"} - standard errors over \code{log(lambda)},
  \item \code{"gradient"} - gradient values over \code{log(lambda)},
  \item \code{"weight"} - mixture weights used in smoothing,
  \item \code{"gof"} - goodness-of-fit values.
}}

\item{gof}{Character. Criterion used for highlighting active variables.
Choices: \code{"none"}, \code{"AIC"}, \code{"BIC"}, \code{"AICc"}, \code{"eBIC"}, \code{"GCV"}, \code{"GIC"}.}

\item{label}{Logical. Whether to annotate curves with variable names.}

\item{legend}{Logical. Whether to display a plot legend.}

\item{...}{Additional graphical parameters, e.g. \code{main}, \code{xlab}, \code{ylab}, \code{xlim}, \code{ylim},
\code{lty}, \code{col}, \code{lwd}, \code{cex.axis}, \code{cex.lab}, \code{cex.main}, \code{gof_lty},
\code{gof_col}, \code{gof_lwd}.}
}
\value{
Produces plots. Does not return an object.
}
\description{
Generates plots of coefficient profiles, standard errors, gradients, weights, or goodness-of-fit criteria
from a fitted \code{\link{islasso.path}} model.
}
\details{
This function visualizes the behavior of the solution path across a sequence of lambda values,
helping diagnose coefficient shrinkage, influence of penalty, and variable selection stability.
}
\examples{
\dontrun{
  n <- 100; p <- 30
  beta <- c(runif(10, -2, 2), rep(0, p - 10))
  sim <- simulXy(n = n, p = p, beta = beta, seed = 1, family = gaussian())
  fit <- islasso.path(y ~ ., data = sim$data, family = gaussian())

  plot(fit, yvar = "coefficients", gof = "AICc", label = TRUE)
  plot(fit, yvar = "se", gof = "AICc")
  plot(fit, yvar = "gradient", gof = "AICc")
  plot(fit, yvar = "gof", gof = "AICc")
}

}
\seealso{
\code{\link{islasso.path}}, \code{\link{GoF.islasso.path}}, \code{\link{summary.islasso.path}},
         \code{\link{coef.islasso.path}}, \code{\link{fitted.islasso.path}}, \code{\link{predict.islasso.path}}
}
\author{
Gianluca Sottile \email{gianluca.sottile@unipa.it}
}
