% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_predictions.R
\name{tidy_trajectories}
\alias{tidy_trajectories}
\title{Build a tidy table with the trajectories for each iteration}
\usage{
tidy_trajectories(
  nm,
  mcmc,
  n_per_chain = NULL,
  n = NULL,
  n_grid = 64,
  dt = NULL,
  grid_size = NULL,
  at = NULL,
  end = NULL,
  use_cache = TRUE,
  cores = NULL
)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{mcmc}{The corresponding output from \code{run_mcmc}.}

\item{n_per_chain}{Integer, number of iterations randomly drawn per
chain. Note that iterations are in sync across chains (in practice,
random iterations are chosen, and then parameter values extracted for
those same iterations from all chains).}

\item{n}{Integer, number of iterations randomly drawn from \code{mcmc}. Note
that iterations are *not* drawn in sync across chains in this case (use
\code{n_per_chain} if you need to have the same iterations taken across
all chains).}

\item{n_grid}{Size of the time grid used to calculate trajectories}

\item{dt, grid_size}{Time step size or grid points, respectively.}

\item{at}{Timepoints at which the predictions should be returned.}

\item{end}{Final timepoint used in the projections.}

\item{use_cache}{Boolean, use cache for faster calculations?}

\item{cores}{Number of cores to use for parallel calculations. Default is
\code{NULL}, which means to use the value stored in
\code{options()[["mc.cores"]]} (or 1 if this value is not set).}
}
\value{
A tidy table containing the mcmc iterations (chain, iteration,
    parameters), the grouping variables from the network model and the
    trajectories.
}
\description{
If neither \code{n_per_chain} and \code{n} are provided, all iterations are
used.
}
\details{
Warning: This function is still maturing and its interface and output might
change in the future.
}
\examples{
tt <- tidy_trajectories(aquarium_mod, aquarium_run, n = 10, cores = 2)
tt

}
