% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_jadeLizardPnL.R
\name{jadeLizardPnL}
\alias{jadeLizardPnL}
\title{Calculates per share (or unit of the underlying) Profit and Loss (PnL) at expiration for Jade Lizard Options Trading Strategy and draws its Bar Plot displaying the PnL at various Spot Prices.}
\usage{
jadeLizardPnL(
  ST,
  XHU,
  XHL,
  XM,
  lcp,
  scp,
  spp,
  hl = 0,
  hu = 1.9,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T}

\item{XHU}{Higher-Upper Strike Price or eXercise price for bought Call}

\item{XHL}{Higher-Low Strike Price or eXercise price for shorted call}

\item{XM}{Strike Price or eXercise price for OTM shorted Put}

\item{lcp}{Long Call Premium}

\item{scp}{Short Call Premium}

\item{spp}{Short Put Premium}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss column in data frame}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
Jade Lizard is a slightly Bullish Option Trading Strategy. It results from combining an OTM (out of the money) short put with OTM bear call spread that consists of buying a OTM higher strike call and selling somewhat lower strike but still OTM call (Stultz, 2019). A trader can use the Jade Lizard Options Strategy for underlying securities, including stocks, or stock indices (Nasdaq, 2022). In the bear call spread component of the Jade Lizard the higher strike call that you buy is further OTM than the lower strike call that you sell (Cohen, 2015). When created properly, this strategy has no upside risk. It is best suited for oversold stocks with high implied volatility (OptionStrat, n.d.). In the article titled Jade Lizard Option Strategies, Tastytrade explains that the strategy is created to have no upside risk, which is done by collecting a total credit greater than the width of the short call spread (Tastytrade, n.d.). OptionStrat demonstrates execution of Jade Lizard Strategy on a stock from North American Markets (OptionStrat, n.d.) and Strategy Builder from Opstra Definedge demonstrates its application in stock index like Nifty or a constituent stock. The Bar Plot clearly shows that the PnL Plotting of Jade Lizard Strategy looks quite similar to the shape that of a lizard.
Goals: This trade retains the premium collected when opened as long as both the short put and vertical bear call spread remain OTM (Stultz, 2019).\cr
Manage: If the price of the underlying security remains within a narrow range, let the options expire worthless. If it is an American option that can be closed before expiration and if a price rally or drop occurs that threatens the short put or the bear call vertical spread, close the vulnerable positions and retain the safe position until it either expires worthless or can be closed for a profit (Stultz, 2019).\cr
Profit: If it is an American option that can be closed before expiration then close the positions when this strategy achieves a profit of 30 percent or more. If the options remain OTM, consider letting the trade expire worthless(Stultz, 2019).\cr
Loss: If it is an American option that can be closed before expiration the close the positions when a loss in premium value becomes 8 percent or less (Stultz, 2019).\cr
}
\details{
According to conceptual details given by Stultz (2019), and a closed form solution is developed for Jade Lizard Strategy and applied to draw the Bar plot in the Plots tab. Further given examples are created, to compute per share Profit and Loss at expiration for Jade Lizard Strategy to demonstrate the strategy through its graph in the Plots tab.
}
\examples{
jadeLizardPnL(10,17,12,15,1,2,5)
jadeLizardPnL(40,45,34,40,2,6,11,hl=0.25,hu=1.25)
jadeLizardPnL(383.7,405,395,385,3.85,6.35,11,hl=0.92,hu=1.075)
}
\references{
Stultz, R. A. (2019). The option strategy desk reference: an essential reference for option traders (First edition.). Business Expert Press.\cr
Nasdaq (2022, April 11). Ultimate Guide to the Jade Lizard Options Strategy. https://www.nasdaq.com/articles/ultimate-guide-to-the-jade-lizard-options-strategy \cr
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
OptionStrat. (n.d.). What is a jade lizard? https://optionstrat.com/build/jade-lizard \cr
Tastytrade. (n.d.). Jade Lizard Option Strategies. https://www.tastytrade.com/concepts-strategies/jade-lizard \cr
https://opstra.definedge.com/strategy-builder \cr
R Graphics Cookbook. (n.d.). Coloring Negative and Positive Bars Differently. https://r-graphics.org/recipe-bar-graph-color-neg \cr
Gross C, Ottolinger P (2016).\emph{ggThemeAssist: Add-in to Customize 'ggplot2' Themes}. R package version 0.1.5, <URL: https://CRAN.R-project.org/package=ggThemeAssist>.
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
