% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{allocateLandscapeCroptypes}
\alias{allocateLandscapeCroptypes}
\title{Allocate croptypes to the landscape}
\usage{
allocateLandscapeCroptypes(
  params,
  rotation_period,
  rotation_sequence,
  rotation_realloc = FALSE,
  prop,
  aggreg,
  algo = "periodic",
  graphic = TRUE
)
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{rotation_period}{number of years before rotation of the landscape. There is no rotation
if rotation_period=0 or rotation_period=Nyears.}

\item{rotation_sequence}{a list, each element of the list contains indices of croptypes that
are cultivated during a period given by "rotation_period". There is no change in cultivated
croptypes if the list contains only one element (e.g. only one vector c(0,1,2), indicating
cultivation of croptypes 0, 1 and 2).}

\item{rotation_realloc}{a logical indicating if a new random allocation of croptypes is
performed when the landscape is rotated (FALSE=static allocation, TRUE=dynamic allocation).
Note that if rotation_realloc=FALSE, all elements of the list "rotation_sequence" must have
the same length, and only the first element of the lists "prop" and "aggreg" will be used.}

\item{prop}{a list of the same size as "rotation_sequence", each element of the list contains
a vector of the proportions (in surface) associated with the croptypes in "rotation_sequence".
A single vector can be given instead of a list if all elements of "rotation_sequence" are
associated with the same proportions.}

\item{aggreg}{a list of the same size as "rotation_sequence", each element of the list is a
single double indicating the degree of
aggregation of the landscape. This double must greater or equal 0; the greater its value,
the higher the degree of spatial aggregation (roughly, aggreg between 0 and 0.1 for fragmented
landscapes, between 0.1 and 0.5 for balanced landscapes, between 0.5 and 3 for aggregated
landscapes, and above 3 for highly aggregated landscapes). A single double can be given
instead of a list if all elements of "rotation_sequence" are associated with the same level
of aggregation.}

\item{algo}{the algorithm used for the computation of the variance-covariance matrix
of the multivariate normal distribution: "exp" for exponential function, "periodic"
for periodic function, "random" for random draw (see details of function multiN).
If algo="random", the parameter aggreg is not used.
Algorithm "exp" is preferable for big landscapes.}

\item{graphic}{a logical indicating if graphics must be generated (TRUE) or not (FALSE).}
}
\value{
a LandsepiParams object with Landscape updated with the layer "croptypeID".
It contains croptype allocation in every polygon of the landscape for all years of simulation.
}
\description{
Updates the landscape of a LandsepiParams object with croptype allocation in
every polygon of the landscape and every year of simulation. Allocation is based on an algorithm
which controls croptype proportions (in surface) and spatio-temporal aggregation.
Note that time, landscape and croptype parameters must be set before allocating
landscape croptypes.
}
\details{
An algorithm based on latent Gaussian fields is used to allocate two different
croptypes across the simulated landscapes (e.g. a susceptible and a resistant cultivar,
denoted as SC and RC, respectively). This algorithm allows the control of the proportions of
each croptype in terms of surface coverage, and their level of spatial aggregation.
A random vector of values is drawn from a multivariate normal distribution with expectation 0
and a variance-covariance matrix which depends on the pairwise distances between
the centroids of the polygons. Next, the croptypes are allocated to different polygons
depending on whether each value drawn from the multivariate normal distribution is above
or below a threshold. The proportion of each cultivar in the landscape is controlled by
the value of this threshold. To allocate more than two croptypes, \code{AgriLand} uses
sequentially this algorithm. For instance, the allocation of three croptypes
(e.g. SC, RC1 and RC2) is performed as follows:
\enumerate{
\item the allocation algorithm is run once to segregate the polygons where the susceptible
cultivar is grown, and
\item the two resistant cultivars (RC1 and RC2) are assigned to the remaining candidate
polygons by re-running the allocation algorithm.
}
}
\examples{
\dontrun{
## Initialisation
simul_params <- createSimulParams(outputDir = getwd())
## Time parameters
simul_params <- setTime(simul_params, Nyears = 10, nTSpY = 120)
## Landscape
simul_params <- setLandscape(simul_params, loadLandscape(1))
## Cultivars
cultivar1 <- loadCultivar(name = "Susceptible", type = "wheat")
cultivar2 <- loadCultivar(name = "Resistant1", type = "wheat")
cultivar3 <- loadCultivar(name = "Resistant2", type = "wheat")
cultivars <- data.frame(rbind(cultivar1, cultivar2, cultivar3), stringsAsFactors = FALSE)
simul_params <- setCultivars(simul_params, cultivars)
## Allocate cultivars to croptypes
croptypes <- loadCroptypes(simul_params, names = c("Susceptible crop"
, "Resistant crop 1"
, "Resistant crop 2"))
croptypes <- allocateCroptypeCultivars(croptypes, "Susceptible crop", "Susceptible")
croptypes <- allocateCroptypeCultivars(croptypes, "Resistant crop 1", "Resistant1")
croptypes <- allocateCroptypeCultivars(croptypes, "Resistant crop 2", "Resistant2")
simul_params <- setCroptypes(simul_params, croptypes)
## Allocate croptypes to landscape        
rotation_sequence <- croptypes$croptypeID ## No rotation -> 1 rotation_sequence element
rotation_period <- 0 ## same croptypes every years
prop <- c(1 / 3, 1 / 3, 1 / 3) ## croptypes proportions
aggreg <- 10 ## aggregated landscape
simul_params <- allocateLandscapeCroptypes(simul_params, rotation_period = rotation_period,
rotation_sequence = rotation_sequence,
rotation_realloc = FALSE, prop = prop, aggreg = aggreg)
simul_params@Landscape
}
}
