% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{anova.lcc}
\alias{anova.lcc}
\title{Compare Likelihoods of Fitted Models from an \code{lcc} Object}
\usage{
\method{anova}{lcc}(object, ..., test = TRUE, type = c("sequential", "marginal"), 
  adjustSigma = TRUE, verbose = FALSE)
}
\arguments{
\item{object}{An object inheriting from class \code{lcc} or \code{lme}.}

\item{...}{Other optional fitted model objects inheriting from classes "lcc" or "lme".}

\item{test}{Logical; if \code{TRUE}, performs likelihood ratio tests to compare models. 
Defaults to \code{TRUE}.}

\item{type}{Character string specifying the type of sum of squares for F-tests. 
Options are "sequential" or "marginal". Defaults to "sequential".}

\item{adjustSigma}{Logical; if \code{TRUE}, adjusts the residual standard error 
for maximum likelihood estimation. Defaults to \code{TRUE}.}

\item{verbose}{Logical; if \code{TRUE}, prints additional model details. 
Defaults to \code{FALSE}.}
}
\description{
Compares the fit of different longitudinal concordance correlation models 
(lcc objects). When comparing multiple models, the function returns a 
data frame with degrees of freedom, log-likelihood, AIC, and BIC for each model. 
For a single model, it returns F-values and P-values for fixed terms in the model.
}
\details{
This function is an adaptation from \code{\link[nlme]{anova.lme}}. 
It assesses whether the addition of terms significantly improves model fit.
}
\examples{
\dontrun{
fm1.aov <- lcc(data = hue, subject = "Fruit", resp = "H_mean", method = "Method", 
               time = "Time", qf = 2, qr = 1)
fm2.aov <- update(fm1.aov, qr = 2)
anova(fm1.aov, fm2.aov)
}

\dontrun{
fm3.aov <- update(fm2.aov, REML = FALSE)
fm4.aov <- update(fm2.aov, REML = FALSE, qf = 3)
anova(fm3.aov, fm4.aov)
}

\dontrun{
fm5.aov <- update(fm2.aov, var.class = varExp, weights.form = "time")
anova(fm1.aov, fm2.aov, fm5.aov)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{summary.lcc}}
}
