% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addStarsImage.R
\name{addStarsImage}
\alias{addStarsImage}
\title{Add stars layer to a leaflet map}
\usage{
addStarsImage(
  map,
  x,
  band = 1,
  colors = "Spectral",
  opacity = 1,
  attribution = NULL,
  layerId = NULL,
  group = NULL,
  project = FALSE,
  method = c("auto", "bilinear", "near", "average", "mode", "cubic", "cubicspline",
    "lanczos", "sum", "min", "q1", "median", "q3", "max", "rms"),
  maxBytes = 4 * 1024 * 1024,
  options = gridOptions(),
  data = getMapData(map),
  ...
)
}
\arguments{
\item{map}{a mapview or leaflet object.}

\item{x}{a stars layer.}

\item{band}{the band number to be plotted.}

\item{colors}{the color palette (see \code{\link[leaflet]{colorNumeric}}) or function
to use to color the raster values (hint: if providing a function, set
\code{na.color} to \code{"#00000000"} to make \code{NA} areas transparent).
The palette is ignored if \code{x} is a SpatRaster with a color table or if
it has RGB channels.}

\item{opacity}{the base opacity of the raster, expressed from 0 to 1}

\item{attribution}{the HTML string to show as the attribution for this layer}

\item{layerId}{the layer id}

\item{group}{the name of the group this raster image should belong to (see
the same parameter under \code{\link[leaflet]{addTiles}})}

\item{project}{if \code{TRUE}, automatically project \code{x} to the map
projection expected by Leaflet (\code{EPSG:3857}); if \code{FALSE}, it's
the caller's responsibility to ensure that \code{x} is already projected,
and that \code{extent(x)} is expressed in WGS84 latitude/longitude
coordinates}

\item{method}{character. Method used for estimating the new cell values of a SpatRaster. One of: 
  
	\code{bilinear}: bilinear interpolation (3x3 cell window). This is used by default if the first layer of \code{x} is not categorical

	\code{average}:  This can be a good choice with continuous variables if the output cells overlap with multiple input cells. 

	\code{near}: nearest neighbor. This is used by default if the first layer of \code{x} is categorical. This method is not a good choice for continuous values.

	\code{mode}: The modal value. This can be a good choice for categrical rasters, if the output cells overlap with multiple input cells. 
  
	\code{cubic}: cubic interpolation (5x5 cell window).

	\code{cubicspline}: cubic B-spline interpolation. (5x5 cell window).

	\code{lanczos}: Lanczos windowed sinc resampling. (7x7 cell window).

	\code{sum}: the weighted sum of all non-NA contributing grid cells.

	\code{min, q1, median, q3, max}: the minimum, first quartile, median, third quartile, or maximum value. 
	
	\code{rms}: the root-mean-square value of all non-NA contributing grid cells.
  }

\item{maxBytes}{the maximum number of bytes to allow for the projected image
(before base64 encoding); defaults to 4MB.}

\item{options}{a list of additional options, intended to be provided by
a call to \code{\link[leaflet]{gridOptions}}}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden.}

\item{...}{currently not used.}
}
\description{
Add stars layer to a leaflet map
}
\details{
This is an adaption of \code{\link[leaflet]{addRasterImage}}. See that documentation
for details.

Note, method \code{auto}, the default, will choose between \code{near} for factorial and
\code{bilinear} for numeric data. All other methods need to be set manually.
}
\examples{
\donttest{
library(stars)
library(leaflet)

tif = system.file("tif/L7_ETMs.tif", package = "stars")
x = read_stars(tif)
leaflet() \%>\%
  addProviderTiles("OpenStreetMap") \%>\%
  addStarsImage(x, project = TRUE)
}

}
