% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sidebar.R
\name{sidebar_pane}
\alias{sidebar_pane}
\title{Create a Sidebar Pane}
\usage{
sidebar_pane(
  title = "Sidebar Title",
  id = NULL,
  icon = icon("caret-right"),
  ...
)
}
\arguments{
\item{title}{A title for the sidebar panel}

\item{id}{An id for the sidebar panel}

\item{icon}{An icon for the sidebar panel}

\item{...}{List of elements to include in the panel}
}
\value{
A \code{shiny.tag} with sidebar-specific HTML classes
}
\description{
Create a Sidebar Pane
}
\examples{
\dontrun{
library(shiny)
sidebar_pane(id = "id", icon = icon("cars"), tags$div())
}
}
\references{
\url{https://github.com/Turbo87/sidebar-v2},
         \url{https://github.com/Turbo87/sidebar-v2/blob/master/doc/usage.md}
}
\seealso{
Other Sidebar Functions: 
\code{\link{addSidebar}()},
\code{\link{closeSidebar}()},
\code{\link{openSidebar}()},
\code{\link{removeSidebar}()},
\code{\link{sidebar_tabs}()}
}
\concept{Sidebar Functions}
