% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeslider.R
\name{timesliderOptions}
\alias{timesliderOptions}
\title{timesliderOptions}
\usage{
timesliderOptions(
  position = c("topright", "bottomleft", "bottomright", "topleft"),
  timeAttribute = "time",
  isEpoch = FALSE,
  startTimeIdx = 0,
  timeStrLength = 19,
  maxValue = -1,
  minValue = 0,
  showAllOnStart = FALSE,
  range = FALSE,
  follow = FALSE,
  alwaysShowDate = FALSE,
  rezoom = NULL,
  sameDate = FALSE
)
}
\arguments{
\item{position}{position of control: "topleft", "topright", "bottomleft", or
"bottomright". Default is \code{topright}.}

\item{timeAttribute}{The column name of the time property.
Default is \code{"time"}}

\item{isEpoch}{whether the time attribute is seconds elapsed from epoch.
Default is \code{FALSE}}

\item{startTimeIdx}{where to start looking for a timestring
Default is \code{0}}

\item{timeStrLength}{the size of \code{yyyy-mm-dd hh:mm:ss} - if milliseconds are
present this will be larger. Default is \code{19}}

\item{maxValue}{Set the maximum value of the slider. Default is \code{-1}}

\item{minValue}{Set the minimum value of the slider. Default is \code{0}}

\item{showAllOnStart}{Specify whether all markers should be initially visible.
Default is \code{FALSE}}

\item{range}{To use a range-slider, set to \code{TRUE.} Default is \code{FALSE}
Default is \code{FALSE}}

\item{follow}{To display only the markers at the specific timestamp specified
by the slider. Specify a value of 1 (or true) to display only a single data
point at a time, and a value of null (or false) to display the current marker
and all previous markers. The range property overrides the follow property.
Default is \code{FALSE}}

\item{alwaysShowDate}{Should the Date always be visible. Default is \code{FALSE}}

\item{rezoom}{Use the rezoom property to ensure the markers being displayed
remain in view. Default is \code{NULL}}

\item{sameDate}{Show only data with the current selected time.
Default is \code{FALSE}}
}
\value{
A list of options for \code{addTimeslider}
}
\description{
A list of options for \code{\link{addTimeslider}}.
}
\references{
\url{https://github.com/dwilhelm89/LeafletSlider}
}
\seealso{
Other Timeslider Functions: 
\code{\link{addTimeslider}()},
\code{\link{removeTimeslider}()}
}
\concept{Timeslider Functions}
