% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes-brackets.R
\name{bracket_options}
\alias{bracket_options}
\alias{bracket_line}
\alias{bracket_square}
\alias{bracket_chevron}
\alias{bracket_round}
\alias{bracket_sigmoid}
\alias{bracket_atan}
\alias{bracket_curvy}
\title{Bracket options}
\usage{
bracket_line()

bracket_square()

bracket_chevron()

bracket_round(angle = 180, n = 100)

bracket_sigmoid(curvature = 10, n = 100)

bracket_atan(curvature = 5, n = 100)

bracket_curvy(angle = 225, n = 100)
}
\arguments{
\item{angle}{A \code{numeric(1)}: the angle in degrees for which a circle piece
is drawn. For \code{bracket_curvy()}, an angle between 180 and 270.}

\item{n}{An \code{integer(1)} number of points to use for the bracket.}

\item{curvature}{A \code{numeric(1)} that controls the curliness of the bracket.
More precisely, it is used to construct the sequence
\code{seq(-curvature, curvature, length.out = n)} over which the logistic or
arctangent functions is evaluated.}
}
\value{
A \verb{<matrix[n, 2]>} with coordinates for points on the brackets.
}
\description{
These functions construct various sorts of brackets. They construct a matrix
that can be supplied as the \code{bracket} argument in \code{\link[=primitive_bracket]{primitive_bracket()}}.
}
\details{
When designing custom bracket shapes, the expectation is both columns are
are a number between 0 and 1. The first column follows the direction of the
guide whereas the second column is orthogonal to that direction.
}
\section{Functions}{
\itemize{
\item \code{bracket_line()}: A simple line as bracket. Has \code{n = 2} points.

\item \code{bracket_square()}: A square bracket. Has \code{n = 4} points.

\item \code{bracket_chevron()}: A chevron (V-shape) that makes a bracket. Has
\code{n = 3} points.

\item \code{bracket_round()}: One circular arc that makes a bracket.

\item \code{bracket_sigmoid()}: Two sigmoid curves stacked on top of one another
to form a bracket.

\item \code{bracket_atan()}: Two arctangent curves stacked on top of one
another to form a bracket.

\item \code{bracket_curvy()}: Four circular arcs that make a bracket.

}}
\examples{
plot(bracket_sigmoid(), type = 'l')
}
