% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorad-summary.R
\name{lorad_summary}
\alias{lorad_summary}
\title{Summarize output from \code{\link[=lorad_estimate]{lorad_estimate()}}}
\usage{
lorad_summary(results)
}
\arguments{
\item{results}{Named character vector returned from \code{\link[=lorad_estimate]{lorad_estimate()}}}
}
\value{
String containing a summary of the supplied \code{results} object
}
\description{
Summarize output from \code{\link[=lorad_estimate]{lorad_estimate()}}
}
\examples{
normals <- rnorm(1000000,0,10)
prob_normals <- dnorm(normals,0,10,log=TRUE) 
paramsdf <- data.frame(normals,prob_normals)
columnkey <- c("normals"="unconstrained", "prob_normals"="posterior")
results <- lorad_estimate(paramsdf, columnkey, 0.5, 'left', 0.1)
lorad_summary(results)
}
