% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediate_iv.R
\name{mediate_iv}
\alias{mediate_iv}
\title{Mediation Analysis for Count and Zero-Inflated Count Data Using Instrumental
 Variable Method}
\usage{
mediate_iv(
  y,
  z,
  m,
  zm.int = FALSE,
  ydist = "poisson",
  mtype = "binary",
  x.IV,
  x.nonIV = NULL,
  tol = 1e-05,
  n.init = 3,
  control = list(),
  conf.level = 0.95,
  sims = 1000
)
}
\arguments{
\item{y}{Outcome variable.}

\item{z}{Treatment variable.}

\item{m}{Mediator variable.}

\item{zm.int}{A logical value. if 'FALSE' the interaction of treatment
by mediator will not be included in the outcome model; if 'TRUE' the interaction
will be included in the outcome model. Default is 'FALSE'.}

\item{ydist}{A character string indicating outcome distribution which will
be used to fit for getting the initial parameter estimates. Can only take
one of the these three values - 'poisson', 'negbin', or 'neyman type a'
Default is 'poisson'. Use 'neyman type a' for zero-inflated outcomes.}

\item{mtype}{A character string indicating mediator type, either 'binary'
or 'continuous'. Default is 'binary'.}

\item{x.IV}{Specifies baseline variable(s) to construct Instrumental Variable(s),
Use \code{cbind()} for 2 or more IVs.}

\item{x.nonIV}{Specifies baseline variable(s) that are not used to construct
Instrumental Variable(s) as covariates. Use \code{cbind()} for 2 or more non
IVs. Default is NULL.}

\item{tol}{Numeric tolerance value for parameter convergence. When the square
root of sum of squared difference between two consecutive set of optimized
parameters less than \code{tol}, then the convergence is reached.
Default is 1e-5.}

\item{n.init}{Number of set of initial parameter values. Default is 3.}

\item{control}{A list of parameters governing the nonlinear optimization
algorithm behavior (to minimize the profile empirical log-likelihood).
This list is the same as that for \code{BBoptim()}, which is a wrapper
for \code{spg()}. \code{control} default is
\code{list(maxit = 1500, M = c(50, 10), ftol=1e-10, gtol = 1e-05,
 maxfeval = 10000, maximize = FALSE, trace = FALSE, triter = 10,
 eps = 1e-07, checkGrad=NULL)}.  See \code{spg} for more details.}

\item{conf.level}{Level of the returned two-sided bootstrap confidence
intervals. The default value, 0.95, is to return the 2.5 and 97.5
percentiles of the simulated quantities.}

\item{sims}{Number of Monte Carlo draws for nonparametric bootstrap.
Default is 1000.}
}
\value{
\code{mediate_iv} returns a list with the following components and
  prints them out in a matrix format:
  \item{beta}{parameter estimates from optimized profile empirical
  log-likelihood.}
  \item{ter, ter.ci}{point estimate for total effect ratio
  and its bootstrap confidence interval.}

  If the interaction between treatment and mediator is not specified, ie,
  zm.int=FALSE, a list of additional components are:
  \item{der, der.ci}{point estimate for controlled direct effect ratio and
  its bootstrap confidence interval.}
  \item{der.nat, der.nat.ci}{point estimate for natural direct effect
  ratio and its bootstrap confidence interval.}
  \item{ier, ier.ci}{point estimate for controlled indirect effect ratio
  and its bootstrap confidence interval.}
  \item{ier.nat, ier.nat.ci}{point estimate for natural indirect effect ratio
  and its bootstrap confidence interval; They are only applicable to
  continuous mediator.}

  If the interaction between treatment and mediator is specified, ie,
  zm.int=TRUE, which is only supported for binary mediator, a list of
  additional components are:
  \item{der.m0, der.m0.ci}{point estimate for controlled direct effect ratio
  when m = 0 and its bootstrap confidence interval.}
  \item{der.m1, der.m1.ci}{point estimate for controlled direct effect ratio
  when m = 1 and its bootstrap confidence interval.}
  \item{der.nat.m0, der.nat.m0.ci}{point estimate for natural direct effect
  ratio when m = 0 and its bootstrap confidence interval.}
  \item{der.nat.m1, der.nat.m1.ci}{point estimate for natural direct effect
  ratio when m = 1 and its bootstrap confidence interval.}
  \item{ier.z0, ier.z0.ci}{point estimate for controlled indirect effect
  ratio when z = 0 and its bootstrap confidence interval.}
  \item{ier.z1, ier.z1.ci}{point estimate for controlled indirect effect
  ratio when z = 1 and its bootstrap confidence interval.}
}
\description{
\loadmathjax{} 'mediate_iv' is used to estimate controlled or natural
direct effect ratio, indirect (mediation) effect ratio for count and
zero-inflated count data using Instrumental Variable (IV) method
described in Guo, Z., Small, D.S., Gansky, S.A., Cheng, J. (2018).
}
\details{
'mediate_iv' is to estimate the controlled and natural direct and
  indirect ratios of randomized treatment around and through mediators when
  there is unmeasured confounding. This function considers count and
  zero-inflated count outcomes, and binary and continuous mediators. The
  estimation uses an instrumental variable approach with empirical
  likelihood and estimating equations, where no parametric assumption is
  needed for the outcome distribution.

  \emph{Controlled effect ratio}

  Given the generalized linear model for the expected potential outcomes:
    \mjsdeqn{f[E(Y(z,m)|x,u)] = \beta_0 + \beta_zz + \beta_mm + \beta_xx + u,}
  where \mjseqn{f} is a log-link function, \mjseqn{\beta_0} is the intercept,
  \mjseqn{z} is the treatment, \mjseqn{m} is pre-specified mediator value, \mjseqn{x}
  are baseline covariates, \mjseqn{\beta_z}, \mjseqn{\beta_m}, \mjseqn{\beta_x} are
  their corresponding coefficients, \mjseqn{u} are unmeasured confounders and
  \mjseqn{Y(z,m)} is the potential outcome under treatment \mjseqn{z} and mediator
  \mjseqn{m}.
  Then the controlled direct effect ratio when the treatment changes from
  \mjseqn{z^\ast} to \mjseqn{z} while keeping the mediator at \mjseqn{m}:

    \mjsdeqn{\frac{E[Y(z,m)|x,u]}{E[Y(z^\ast,m)|x,u]} = \exp[\beta_z(z-z^\ast)]}
    and the controlled indirect effect ratio when the mediator changes from
    \mjseqn{m^\ast} to \mjseqn{m} while keeping the treatment at \mjseqn{z}:
    \mjsdeqn{\frac{E[Y(z,m)|x,u]}{E[Y(z,m^\ast)|x,u]} = \exp[\beta_m(m-m^\ast)]}

  \emph{Natural effect ratio}

  Given a generalized linear model for the expected potential outcomes and
  a model for the mediator:
  \mjsdeqn{f[E(Y(z,M^{z^\ast}|x,u))] = \beta_0 + \beta_zz + \beta_mM^{z^\ast} + \beta_xx
   + u,}
  where \mjseqn{f} is a log-link function, \mjseqn{M^{z^\ast}} is the potential
  mediator under treatment \mjseqn{z^\ast}, and \mjseqn{Y(z,M^{z^\ast})} is
  the potential outcome under treatment \mjseqn{z} and potential mediator
  \mjseqn{M^{z^\ast}}
  \mjsdeqn{h[E(M^{z^\ast}|x,u)] = \alpha_0 + \alpha_zz^\ast + \alpha_xx +
  \alpha_{IV}z^\ast x^{IV} + u,}
  where \mjseqn{h} is an identity function for continuous mediators and logit
  function for binary mediators; \mjseqn{\alpha_{IV}} is the coefficient for
  instrumental variables \mjseqn{x^{IV}}, \mjseqn{z^\ast x^{IV}}, interaction of randomized
  treatment and instrumental variables, and \mjseqn{M^z} is the potential mediator
  under treatment \mjseqn{z^\ast}.
  Then the natural direct effect ratio is:
 \mjsdeqn{\frac{E[Y(z,M^{z^\ast})|x,u]}{E[Y(z^\ast,M^{z^\ast}|x,u]} = \exp[\beta_z(z-z^\ast)].}
 And the natural indirect effect ratio with a continuous mediator is:
 \mjsdeqn{\frac{E[Y(z,M^z)|x,u]}{E[Y(z,M^{z^\ast})|x,u]} = \exp[\beta_m\alpha_z(z-z^\ast)
 + \beta_m\alpha_{IV}x^{IV}(z-z^\ast)].}
 The natural indirect effect ratio with a binary mediator is:
 \mjsdeqn{\frac{E[Y(z,M^z)|x,u]}{E[Y(z,M^{z^\ast})|x,u]}
  = \frac{P(M^z = 1|x,u)\exp(\beta_m) + P(M^z = 0|x, u)}
  {P(M^{z^\ast} = 1|x,u) \exp(\beta_m) + P(M^{z^\ast} = 0|x, u)}. }

  The parameters are estimated by the maximized empirical likelihood
  estimates, which are solutions to the estimating equations that maximizes
  the empirical likelihood. See details in Guo, Z., Small, D.S., Gansky,
  S.A., Cheng, J. (2018).
}
\examples{
# For illustration purposes a small number of bootstrap iterations are used
data("midvd_bt100")
# The outcome is Poisson distribution
ee <- mediate_iv(y = midvd_bt100$Untreated_W3,
                 z = midvd_bt100$intervention,
                 m = midvd_bt100$PBrush_6, ydist = "poisson",
                 mtype = "binary", x.IV = midvd_bt100$BrushTimes_W2,
                 tol = 0.5, n.init = 1,
                 control = list(maxit = 15, ftol = 0.5, gtol = 0.5,
                                trace = FALSE),
                 sims = 3)

}
\references{
Guo, Z., Small, D.S., Gansky, S.A., Cheng, J. (2018), Mediation analysis
  for count and zero-inflated count data without sequential ignorability
  and its application in dental studies. Journal of the Royal Statistical
  Society, Series C.; 67(2):371-394.

 Ismail AI, Ondersma S, Willem Jedele JM, et al. (2011) Evaluation of
 a brief tailored motivational intervention to prevent early childhood
 caries.
 Community Dentistry and Oral Epidemiology 39: 433–448.
}
\seealso{
\code{\link[emplik]{el.test}}, \code{\link[BB]{BBoptim}}, \code{\link[BB]{spg}}
}
\author{
Nancy Cheng,
  \email{Nancy.Cheng@ucsf.edu}; Zijian Guo,
  \email{zijguo@stat.rutgers.edu}; Jing Cheng,
  \email{Jing.Cheng@ucsf.edu}.
}
