% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_cond_indirect_effect.R
\name{print.cond_indirect_effects}
\alias{print.cond_indirect_effects}
\alias{as.data.frame.cond_indirect_effects}
\title{Print a
'cond_indirect_effects' Class Object}
\usage{
\method{print}{cond_indirect_effects}(
  x,
  digits = 3,
  annotation = TRUE,
  pvalue = NULL,
  pvalue_digits = 3,
  se = NULL,
  level = 0.95,
  se_ci = TRUE,
  ...
)

\method{as.data.frame}{cond_indirect_effects}(
  x,
  row.names = NULL,
  optional = NULL,
  digits = 3,
  add_sig = TRUE,
  pvalue = NULL,
  pvalue_digits = 3,
  se = NULL,
  level = 0.95,
  se_ci = TRUE,
  to_string = FALSE,
  ...
)
}
\arguments{
\item{x}{The output of
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}.}

\item{digits}{Number of digits to
display. Default is 3.}

\item{annotation}{Logical. Whether
the annotation after the table of
effects is to be printed. Default is
\code{TRUE.}}

\item{pvalue}{Logical. If \code{TRUE},
asymmetric \emph{p}-values based on
bootstrapping will be printed if
available. Default to \code{FALSE} if
confidence intervals have already
computed. Default to \code{TRUE} if
no confidence intervals have been
computed and the original standard
errors are to be used. See Details
on when the original standard errors
will be used by default.}

\item{pvalue_digits}{Number of decimal
places to display for the \emph{p}-values.
Default is 3.}

\item{se}{Logical. If \code{TRUE} and
confidence intervals are available,
the standard errors of the estimates
are also printed. They are simply the
standard deviations of the bootstrap
estimates or Monte Carlo simulated
values, depending on the method used
to form the confidence intervals.
Default to \code{FALSE} if
confidence intervals are available.
Default to \code{TRUE} if
no confidence intervals have been
computed and the original standard
errors are to be used. See Details
on when the original standard errors
will be used by default.}

\item{level}{The level of confidence
for the confidence intervals computed
from the original standard errors. Used only for
paths without mediators and both
\code{x}- and \code{y}-variables are not
standardized.}

\item{se_ci}{Logical. If \code{TRUE} and
confidence interval has not been
computed, the function will try
to compute them from stored
standard errors if the original
standard errors are to be used.
Ignored
if confidence intervals have already
been computed. Default
to \code{TRUE}.}

\item{...}{Other arguments. Not
used.}

\item{row.names}{Not used. Included
to be compatible with the generic
method.}

\item{optional}{Not used. Included
to be compatible with the generic
method.}

\item{add_sig}{Whether a column
of significance test results
will be added. Default is \code{TRUE}.}

\item{to_string}{If \code{TRUE}, numeric
columns will be converted to string
columns, formatted based on \code{digits}
and \code{pvalue_digits}. For printing.
Default is \code{FALSE}.}
}
\value{
The \code{print}-method
returns \code{x} invisibly.
Called for its side effect.

The \code{as.data.frame}-method
returns a data frame with
the conditional effects and
confidence intervals (if available),
as well as other columns requested.
}
\description{
Print the content of the
output of \code{\link[=cond_indirect_effects]{cond_indirect_effects()}}
}
\details{
The \code{print} method of the
\code{cond_indirect_effects}-class object.

If bootstrapping confidence intervals
were requested, this method has the
option to print
\emph{p}-values computed by the
method presented in Asparouhov and Muthén (2021).
Note that these \emph{p}-values are asymmetric
bootstrap \emph{p}-values based on the
distribution of the bootstrap estimates.
They not computed based on the
distribution under the null hypothesis.

For a \emph{p}-value of \emph{a}, it means that
a 100(1 - \emph{a})\% bootstrapping confidence
interval
will have one of its limits equal to
0. A confidence interval
with a higher confidence level will
include zero, while a confidence
interval with a lower confidence level
will exclude zero.
\subsection{Using Original Standard Errors}{

If these conditions are met, the
stored standard errors, if available,
will be used test an effect and
form it confidence interval:
\itemize{
\item Confidence intervals have not been
formed (e.g., by bootstrapping or
Monte Carlo).
\item The path has no mediators.
\item The model has only one group.
\item The path is moderated by one or
more moderator.
\item Both the \code{x}-variable and the
\code{y}-variable are not standardized.
}

If the model is fitted by OLS
regression (e.g., using \code{\link[stats:lm]{stats::lm()}}),
then the variance-covariance matrix
of the coefficient estimates will be
used, and the \emph{p}-value and confidence
intervals are computed from the \emph{t}
statistic.

If the model is fitted by structural
equation modeling using \code{lavaan}, then
the variance-covariance computed by
\code{lavaan} will be used, and the \emph{p}-value
and confidence intervals are computed
from the \emph{z} statistic.
}

\subsection{Caution}{

If the model is fitted by structural
equation modeling and has moderators,
the standard errors, \emph{p}-values,
and confidence interval computed
from the variance-covariance matrices
for conditional effects
can only be trusted if all covariances
involving the product terms are free.
If any of them are fixed, for example,
fixed to zero, it is possible
that the model is not invariant to
linear transformation of the variables.
}

The method \code{as.data.frame()} for
\code{cond_indirect_effects} objects is
used to convert this class of objects
to data frames. Used internally by the
print method but can also be used for
getting a data frame with columns such
as \emph{p}-values and standard errors added.
}
\section{Functions}{
\itemize{
\item \code{as.data.frame(cond_indirect_effects)}: The \code{as.data.frame}-method
for \code{cond_indirect_effects} objects.
Used internally by the \code{print}-method
but can also be used directly.

}}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ a1 * x  + d1 * w1 + e1 * x:w1
m2 ~ a2 * x
y  ~ b1 * m1 + b2 * m2 + cp * x
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE, se = "none", baseline = FALSE)

# Conditional effects from x to m1 when w1 is equal to each of the default levels
cond_indirect_effects(x = "x", y = "m1",
                      wlevels = "w1", fit = fit)

# Conditional Indirect effect from x1 through m1 to y,
# when w1 is equal to each of the default levels
out <- cond_indirect_effects(x = "x", y = "y", m = "m1",
                      wlevels = "w1", fit = fit)
out

print(out, digits = 5)

print(out, annotation = FALSE)



# Convert to data frames

as.data.frame(out)

as.data.frame(out, to_string = TRUE)

}
\references{
Asparouhov, A., & Muthén, B. (2021). Bootstrap p-value computation.
Retrieved from https://www.statmodel.com/download/FAQ-Bootstrap\%20-\%20Pvalue.pdf
}
\seealso{
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}} and
\code{\link[=cond_effects]{cond_effects()}}
}
