% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_vreg.R
\name{vreg}
\alias{vreg}
\title{Create a model component object for a regression component in the variance function of a
gaussian sampling distribution}
\usage{
vreg(
  formula = NULL,
  remove.redundant = FALSE,
  sparse = NULL,
  X = NULL,
  prior = NULL,
  Q0 = NULL,
  b0 = NULL,
  name = ""
)
}
\arguments{
\item{formula}{a formula for the regression effects explaining the log-variance.
Variable names are looked up in the data frame passed as \code{data} argument to
\code{\link{create_sampler}} or \code{\link{generate_data}}, or in \code{environment(formula)}.}

\item{remove.redundant}{whether redundant columns should be removed from the design matrix.
Default is \code{FALSE}.}

\item{sparse}{whether the model matrix associated with \code{formula} should be sparse.
The default is determined by a simple heuristic based on storage size.}

\item{X}{a (possibly sparse) design matrix can be specified directly, as an alternative to the
creation of one based on \code{formula}. If \code{X} is specified \code{formula} is ignored.}

\item{prior}{prior specification for the coefficients. A normal prior can be
specified using function \code{\link{pr_normal}}. Alternatively, fixed values for
the coefficients can be specified using \code{\link{pr_fixed}}, e.g. to generate
data with given coefficients.}

\item{Q0}{prior precision matrix for the regression effects. The default is a
zero matrix corresponding to a noninformative improper prior.
DEPRECATED, please use argument \code{prior} instead, i.e.
\code{prior = pr_normal(mean = b0.value, precision = Q0.value)}.}

\item{b0}{prior mean for the regression effect. Defaults to a zero vector.
DEPRECATED, please use argument \code{prior} instead, i.e.
\code{prior = pr_normal(mean = b0.value, precision = Q0.value)}.}

\item{name}{the name of the model component. This name is used in the output of the
MCMC simulation function \code{\link{MCMCsim}}. By default the name will be 'vreg'
with the number of the variance model term attached.}
}
\value{
An object with precomputed quantities and functions for sampling from
 prior or conditional posterior distributions for this model component,
 intended for internal use by other package functions.
}
\description{
This function is intended to be used on the right hand side of the \code{formula.V} argument to
\code{\link{create_sampler}} or \code{\link{generate_data}}.
}
\references{
E. Cepeda and D. Gamerman (2000).
   Bayesian modeling of variance heterogeneity in normal regression models.
   Brazilian Journal of Probability and Statistics, 207-221.

 T.I. Lin and W.L. Wang (2011).
   Bayesian inference in joint modelling of location and scale parameters
   of the t distribution for longitudinal data.
   Journal of Statistical Planning and Inference 141(4), 1543-1553.
}
