% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_maps.R
\name{plot_map_grid}
\alias{plot_map_grid}
\title{Arrange Multiple tmap Plots in a Grid}
\usage{
plot_map_grid(maps, ncol = 2)
}
\arguments{
\item{maps}{A list of tmap objects.}

\item{ncol}{Number of columns in the grid (default is 2).}
}
\value{
A tmap object representing arranged maps.
}
\description{
Arrange a list of tmap objects into a grid layout.
}
\examples{
\donttest{
library(sf)
library(tmap)

# Load sample spatial data
nc <- st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

# Add mock variables to map
nc$var1 <- runif(nrow(nc), 0, 100)
nc$var2 <- runif(nrow(nc), 10, 200)

# Create individual maps
map1 <- tm_shape(nc) + tm_fill("var1", title = "Variable 1")
map2 <- tm_shape(nc) + tm_fill("var2", title = "Variable 2")

# Arrange the maps in a grid using your function
plot_map_grid(list(map1, map2), ncol = 2)
}
}
