% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survData.R
\name{survData_join}
\alias{survData_join}
\title{Joins a concentration with a survival data set into an argument for 'survData'
when the concentration varies over time}
\usage{
survData_join(x, y)
}
\arguments{
\item{x}{a \code{data.frame} containing the following three columns:
\itemize{
\item \code{replicate}: a vector of class \code{integer} or \code{factor} for replicate
identification
\item \code{time}: a vector of class \code{integer} with time points, min value must be 0
\item \code{Nsurv}: a vector of class \code{integer} providing the number of
alive individuals at some or all time points for each replicate
}}

\item{y}{a \code{data.frame} containing the following three columns:
\itemize{
\item \code{replicate}: a vector of class \code{integer} or factor for replicate
identification
\item \code{time}: a vector of class \code{integer} with time points, min value must be 0
\item \code{conc}: a vector of class \code{numeric} providing the concentration
 at some or all time points for each replicate
}}
}
\value{
a dataframe suitable for `survData`
}
\description{
This function joins two data sets, one for exposure measurements, the other
for survival measurements, into a single dataframe that can be used
with the \code{survData} function.
}
