% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{moveplot3}
\alias{moveplot3}
\title{Move plot 3}
\usage{
moveplot3(
  bp,
  time.var,
  group.var,
  move = TRUE,
  hulls = TRUE,
  scale.var = 5,
  target = NULL
)
}
\arguments{
\item{bp}{biplot object from biplotEZ}

\item{time.var}{time variable}

\item{group.var}{group variable}

\item{move}{whether to animate (TRUE) or facet (FALSE) samples and variables, according to time.var}

\item{hulls}{whether to display sample points or convex hulls}

\item{scale.var}{scaling the vectors representing the variables}

\item{target}{Target data set to which all biplots should be matched consisting of the the same dimensions. If not specified, the centroid of all available biplot sample coordinates from \code{time.var} will be used. Default \code{NULL}.}
}
\value{
\item{bp}{Returns the elements of the biplot object \code{bp} from \code{biplotEZ}.}
\item{iter_levels}{The levels of the time variable.}
\item{coord_set}{The coordinates of the configurations before applying Generalised Orthogonal Procrustes Analysis.}
\item{GPA_list}{The coordinates of the configurations after applying Generalised Orthogonal Procrustes Analysis.}
\item{plot}{An animated or a facet of biplots based on the dynamic frame.}
}
\description{
Create animated biplot on samples and variables in a biplot with a given target
}
\examples{
data(Africa_climate)
data(Africa_climate_target)
bp <- biplotEZ::biplot(Africa_climate, scaled = TRUE) |> biplotEZ::PCA()
bp |> moveplot3(time.var = "Year", group.var = "Region", hulls = TRUE,
move = FALSE, target = NULL)
\donttest{
if(interactive()) {
bp |> moveplot3(time.var = "Year", group.var = "Region", hulls = TRUE,
move = TRUE, target = NULL)}}
bp |> moveplot3(time.var = "Year", group.var = "Region", hulls = TRUE,
move = FALSE, target = Africa_climate_target)
}
