% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals_and_scales.R
\name{maxeven}
\alias{maxeven}
\title{Maximally even scales}
\usage{
maxeven(card, edo = 12, floor = TRUE)
}
\arguments{
\item{card}{Number of notes in the scale. Numeric.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{floor}{Boolean determining how to quantize. Defaults to \code{TRUE} causing the
quantization to round down. If \code{FALSE} rounds to the nearest value.}
}
\value{
Numeric vector of length \code{card} representing a scale of \code{card} notes.
}
\description{
Scales which are "maximally even" divisions of some equal-tempered universe have
several musically interesting properties. When a maximally even scale has a number
of notes (\code{card}) that is coprime to the size of the equal-tempered universe, the
maximally even scale is called a "non-degenerate well-formed" or "moment of symmetry"
scale. When its size divides the equal temperament, it is a perfectly even scale. When
it is neither coprime nor a divisor, it produces a scale with a structure like the
octatonic (i.e. a union of perfectly even scales, or a well-formed scale with a period
smaller than the octave). The scale is generated by quantizing a perfectly even scale
to the chosen chromatic cardinality. Two quantization options are offered (rounding down
and rounding to the nearest value).
}
\examples{
maxeven(7, 12)
maxeven(6, 15)
maxeven(6, 15, floor=FALSE)

diatonic_in_19 <- maxeven(7, 19)
tresillo <- maxeven(3,8)
}
