% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signvector.R
\name{svzero_fingerprint}
\alias{svzero_fingerprint}
\title{Distinguish different types of interval equalities}
\usage{
svzero_fingerprint(set, ineqmat = NULL, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to strings "white," "black", "gray", "roth", "infrared",
"pastel", "rosy", "infrared", or "anaglyph", giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}},
\code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}}, \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, or \code{\link[=make_anaglyph_ineqmat]{make_anaglyph_ineqmat()}}. For other
arrangements, this parameter accepts explicit matrices.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric vector with 3 entries: the number of 'normal' hyperplanes
the set lies on, the number of 'exceptional' hyperplanes, and the
number of hyperplanes which compare a formal tritone to itself.
}
\description{
Not all hyperplanes are made equal. Those which represent "formal tritone"
comparisons and those which are "exceptional" because they check a
scale degree twice ("Modal Color Theory," 40-41) play a different role
in the structure of the hyperplane arrangement than the rest. This function
returns a "fingerprint" of a scale which is like \code{\link[=countsvzeroes]{countsvzeroes()}} but
which counts the different types of hyperplane separately.
}
\examples{
# Two hexachords on the same number of hyperplanes but with different fingerprints
hex1 <- c(0, 1, 3, 5, 8, 9)
hex2 <- c(0, 1, 3, 5, 6, 9)
countsvzeroes(hex1) == countsvzeroes(hex2)
svzero_fingerprint(hex1)
svzero_fingerprint(hex2)

# Their brightness graphs make their difference more apparent:
brightnessgraph(hex1)
brightnessgraph(hex2)

}
