% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_sc.R
\name{downsample}
\alias{downsample}
\title{Downsample ScPhyloExpressionSet}
\usage{
downsample(phyex_set, downsample = 10)
}
\arguments{
\item{phyex_set}{A ScPhyloExpressionSet object}

\item{downsample}{Integer, number of cells to keep per identity (default: 10)}
}
\value{
A new ScPhyloExpressionSet object with downsampled cells
}
\description{
Create a downsampled copy of a ScPhyloExpressionSet object with fewer cells per identity.
}
\details{
This function creates a new ScPhyloExpressionSet with a subset of cells, maintaining
the same proportional representation across identities. The sampling is stratified 
by the current \code{selected_idents} grouping. All metadata and reductions are 
filtered to match the selected cells.
}
\examples{
# Downsample to 20 cells per identity
small_set <- downsample(example_phyex_set_sc, downsample = 20)

# Change grouping and downsample
example_phyex_set_sc@selected_idents <- "day"
treatment_set <- downsample(example_phyex_set_sc, downsample = 15)
}
