% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_signature_transformed.R
\name{plot_signature_transformed}
\alias{plot_signature_transformed}
\title{Plot Signature Under Different Transformations}
\usage{
plot_signature_transformed(phyex_set, transformations = COUNT_TRANSFORMS, ...)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object (BulkPhyloExpressionSet or ScPhyloExpressionSet)}

\item{transformations}{Named list of transformation functions (default: COUNT_TRANSFORMS)}

\item{...}{Additional arguments passed to plot_signature_multiple}
}
\value{
A ggplot2 object showing signatures under different transformations
}
\description{
Compare transcriptomic signatures under various data transformations
to assess the robustness of phylotranscriptomic patterns.
}
\details{
This function applies different transformations to the same dataset and
compares the resulting transcriptomic signatures. This is useful for assessing
whether phylotranscriptomic patterns are robust to different data processing
approaches or are artifacts of specific transformations.

The analysis works with both bulk and single-cell data, helping to determine
whether phylotranscriptomic patterns are consistent across different
normalization and transformation methods.
}
\examples{
# Single-cell data with custom transformations

phyex_set <- example_phyex_set

custom_transforms <- list(raw = identity, log = log1p)
p <- plot_signature_transformed(phyex_set, transformations = custom_transforms)

}
