% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_env_data.R
\name{correct_env_data}
\alias{correct_env_data}
\title{Internal function that prepares downloaded NEON data for flux processing}
\usage{
correct_env_data(input_data)
}
\arguments{
\item{input_data}{Required. Nested data frame from acquire_neon_data.}
}
\value{
List of all QF flags over time period and Data frame of environmental measurements for flux computation
}
\description{
This file takes data frame from acquire_neon_data and:
1) Takes the needed components (QF and measurement flags) for soil water, temperature, co2, binding them together in a tidy data frame
2) Interpolates across the measurements
3) Merges air pressure data into this data frame
}
\examples{
\donttest{
corrected_data <- correct_env_data(sjer_env_data_2022_06)
}
}
\author{
John Zobitz \email{zobitz@augsburg.edu}
}
