% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.NeuralGAM.R, R/uncertainty_estimation.R
\name{.joint_se_eta_mcdropout}
\alias{.joint_se_eta_mcdropout}
\title{Internal helper: joint epistemic SE on link scale}
\usage{
.joint_se_eta_mcdropout(ngam, x, forward_passes = 300, verbose = 0)

.joint_se_eta_mcdropout(ngam, x, forward_passes = 300, verbose = 0)
}
\arguments{
\item{ngam}{Fitted \code{neuralGAM} object.}

\item{x}{New data frame of covariates.}

\item{forward_passes}{Number of MC Dropout passes (default 300).}

\item{verbose}{Verbosity (0/1).}
}
\value{
A numeric vector of length \code{nrow(x)} giving epistemic SEs on the link scale.

A numeric vector of length \code{nrow(x)} giving epistemic SEs on the link scale.
}
\description{
Computes joint epistemic standard errors on the link scale by aggregating
across all smooth terms via MC Dropout, capturing cross-term covariance.
Parametric model uncertainty (from the linear submodel) is added assuming
independence from NN-based epistemic uncertainty.

Computes joint epistemic standard errors on the link scale by aggregating
across all smooth terms via MC Dropout, capturing cross-term covariance.
Parametric model uncertainty (from the linear submodel) is added assuming
independence from NN-based epistemic uncertainty.
}
\details{
Steps:
\enumerate{
\item Parametric part: mean + variance from linear model.
\item Nonparametric part: pass-level sums across all smooths.
\item Joint across-pass variance captures covariance between smooths.
\item Combined with parametric variance (assumed independent).
}

Steps:
\enumerate{
\item Parametric part: mean + variance from linear model.
\item Nonparametric part: pass-level sums across all smooths.
\item Joint across-pass variance captures covariance between smooths.
\item Combined with parametric variance (assumed independent).
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
\keyword{internal}
