% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSspherical.R
\name{SSspherical}
\alias{SSspherical}
\alias{spherical}
\title{self start for spherical function}
\usage{
spherical(x, a, b, xs)

SSspherical(x, a, b, xs)
}
\arguments{
\item{x}{input vector}

\item{a}{the intercept}

\item{b}{the difference between the intercept and the asymptote, so that a + b = asymptote}

\item{xs}{break-point of transition between nonlinear and plateau}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

spherical: vector of the same length as x using the spherical function
}
\description{
Self starter for a spherical function with parameters a (intercept), b (see below), xs (break-point)
}
\details{
This equation was found in a publication by Dobermann et al. (2011) \doi{doi:10.2134/agronj2010.0179}

This function is nonlinear when \eqn{x < xs} and flat (\eqn{asymptote = a + b}) when \eqn{x >= xs}.
}
\examples{
\donttest{
require(ggplot2)
set.seed(123)
x <- seq(0, 400, length.out = 50)
y <- spherical(x, 2, 5, 200) + rnorm(length(x), sd = 0.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSspherical(x, a, b, xs), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
## Confidence intervals
confint(fit)
}

}
