% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressionFromAttributeValues.R
\name{expressionFromAttributeValues}
\alias{expressionFromAttributeValues}
\title{Generates a query expression for matching a multi-value transcript/participant
attribute, for use with \link{getMatches}}
\usage{
expressionFromAttributeValues(transcript.attribute, values, not = FALSE)
}
\arguments{
\item{transcript.attribute}{The transcript attribute to filter by.}

\item{values}{A list of possible values for transcript.attribute.}

\item{not}{Whether to match the given IDs (FALSE), or everything \emph{except} the
given IDs.}
}
\value{
A transcript query expression which can be passed as the
transcript.expression parameter of \link{getMatches} or the expression parameter
of \link{getMatchingTranscriptIds}
}
\description{
This function generates a query expression fragment which can be passed as
the transcript.expression or participant.expression parameter of \link{getMatches}, (or
the expression parameter of \link{getMatchingTranscriptIds} or
\link{getMatchingParticipantIds}) using a list of possible values for a given
transcript attribute.
}
\details{
The attribute defined by transcript.attribute is expected to have possibly more than
one value. If it can have only one value, use \link{expressionFromAttributeValue} instead.
}
\examples{
\dontrun{
## Perform a search
languages <- c("en","es")
results <- getMatches(labbcat.url, list(segment="I"),
                      participant.expression = expressionFromAttributeValues(
                            "participant_languagesSpoken", languages))
}
}
\seealso{
\link{expressionFromAttributeValue}

\link{expressionFromTranscriptTypes}

\link{expressionFromIds}

\link{getMatches}
}
\keyword{search}
