% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMatchingAnnotationData.R
\name{getMatchingAnnotationData}
\alias{getMatchingAnnotationData}
\title{Gets binary data for annotations that match a particular pattern.}
\usage{
getMatchingAnnotationData(labbcat.url, expression, path = "")
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{expression}{An expression that determines which annotations match. This must
match by either id or layer.id.
The expression language is currently not well defined, but is based on JavaScript
syntax. e.g.
\itemize{
\item \code{id == 'e_144_17346'}
\item \verb{['e_144_17346', 'e_144_17347', 'e_144_17348'].includes(id)}
\item \code{layer.id == 'mediapipe' && graph.id == 'AdaAicheson-01.trs'}
}}

\item{path}{Optional path to directory where the files should be saved.}
}
\value{
The names of the files.
}
\description{
In some annotation layers, the annotations have not only a textual label, but also
binary data associated with it; e.g. an image or a data file. In these cases, the 'type'
of the layer is a MIME type, e.g. 'image/png'.
This function gets annotations that match the given expression on a MIME-typed layer,
and retrieves the binary data as files, whose names are returned by the function.
}
\examples{
\dontrun{
## Get mediapipe image annotations for the eleventh second of a transcript
expression = paste(sep="&&",
               "layer.id == 'mediapipe'",
               "graph.id == 'AP511_MikeThorpe.eaf'",
               "start.offset >= 10",
               "end.offset < 11")
png.files <- getMatchingAnnotationData(labbcat.url, expression, path="png")
}
}
\seealso{
\itemize{
\item \link{getMatchingAnnotations}
\item \link{getFragmentAnnotationData}
}
}
\keyword{TextGrid}
\keyword{fragment}
\keyword{sample}
