% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcriptUploadParameters.R
\name{transcriptUploadParameters}
\alias{transcriptUploadParameters}
\title{Set the parameters of a transcript already uploaded with transcriptUpload.}
\usage{
transcriptUploadParameters(labbcat.url, id, parameters, no.progress = FALSE)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{Upload ID returned by the prior call to transcriptUpload().}

\item{parameters}{A named list where each name is the name of a parameter returned by
transcriptUpload(), and the value is the parameters value.}

\item{no.progress}{TRUE to suppress visual progress bar. Otherwise, progress bar will be
shown when interactive().}
}
\value{
The ID of the new transcript in the corpus
}
\description{
The second part of a transcript upload process started by a call to transcriptUpload(),
which specifies values for the parameters required to save the uploaded transcript to
LaBB-CAT's database.
}
\details{
\emph{NB} Using transcriptUpload and transcriptUploadParameters is an alternative to using
newTranscript or updateTranscript.

If the response includes more parameters, then this method should be called again
to supply their values.
}
\examples{
\dontrun{
## Get attributes for new transcript
corpus <- getCorpusIds(labbcat.url)[1]
transcript.type.layer <- getLayer(labbcat.url, "transcript_type")
transcript.type <- transcript.type.layer$validLabels[[1]]

## upload transcript and its media
result <- transcriptUpload(labbcat.url, "my-transcript.eaf", "my-transcript.wav", FALSE)

## use the default parameter values
parameterValues <- list()
for(p in 1:length(parameters$name)) parameterValues[parameters$name[p]] <- parameters$value[p]

## set the upload parameters to finalise the upload
transcript.id <- transcriptUploadParameters(labbcat.url, result$id, parameterValues)
}
}
\seealso{
\itemize{
\item \link{transcriptUpload}
\item \link{transcriptUploadDelete}
\item \link{newTranscript}
\item \link{updateTranscript}
}
}
\keyword{management}
\keyword{transcript}
