% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcFno2.R
\name{calcFno2}
\alias{calcFno2}
\title{Estimate NO2/NOX emission ratios from monitoring data}
\usage{
calcFno2(input, tau = 60, user.fno2, main = "", xlab = "year", ...)
}
\arguments{
\item{input}{A data frame with the following fields. \code{nox} and\code{no2}
(roadside NOX and NO2 concentrations), \code{back_nox}, \code{back_no2} and
\code{back_o3} (hourly background concentrations of each pollutant). In
addition \code{temp} (temperature in degrees Celsius) and \code{cl} (cloud
cover in Oktas). Note that if \code{temp} and \code{cl} are not available,
typical means values of 11 deg. C and cloud = 3.5 will be used.}

\item{tau}{Mixing time scale. It is unlikely the user will need to adjust
this. See details below.}

\item{user.fno2}{User-supplied f-NO2 fraction e.g. 0.1 is a NO2/NOX ratio of
10\% by volume. \code{user.no2} will be applied to the whole time series and
is useful for testing "what if" questions.}

\item{main}{Title of plot if required.}

\item{xlab}{x-axis label.}

\item{...}{
  Arguments passed on to \code{\link[=scatterPlot]{scatterPlot}}
  \describe{
    \item{\code{mydata}}{A data frame containing at least two numeric variables to plot.}
    \item{\code{x}}{Name of the x-variable to plot. Note that x can be a date field or a
factor. For example, \code{x} can be one of the \code{openair} built in
types such as \code{"year"} or \code{"season"}.}
    \item{\code{y}}{Name of the numeric y-variable to plot.}
    \item{\code{z}}{Name of the numeric z-variable to plot for \code{method = "scatter"}
or \code{method = "level"}. Note that for \code{method = "scatter"} points
will be coloured according to a continuous colour scale, whereas for
\code{method = "level"} the surface is coloured.}
    \item{\code{method}}{Methods include \dQuote{scatter} (conventional scatter plot),
\dQuote{hexbin} (hexagonal binning using the \code{hexbin} package).
\dQuote{level} for a binned or smooth surface plot and \dQuote{density} (2D
kernel density estimates).}
    \item{\code{group}}{The grouping variable to use, if any. Setting this to a variable
in the data frame has the effect of plotting several series in the same
panel using different symbols/colours etc. If set to a variable that is a
character or factor, those categories or factor levels will be used
directly. If set to a numeric variable, it will split that variable in to
quantiles.}
    \item{\code{avg.time}}{This defines the time period to average to. Can be
\dQuote{sec}, \dQuote{min}, \dQuote{hour}, \dQuote{day}, \dQuote{DSTday},
\dQuote{week}, \dQuote{month}, \dQuote{quarter} or \dQuote{year}. For much
increased flexibility a number can precede these options followed by a
space. For example, a timeAverage of 2 months would be \code{period = "2 month"}. See function \code{timeAverage} for further details on this. This
option se useful as one method by which the number of points plotted is
reduced i.e. by choosing a longer averaging time.}
    \item{\code{data.thresh}}{The data capture threshold to use (\\%) when aggregating
the data using \code{avg.time}. A value of zero means that all available
data will be used in a particular period regardless if of the number of
values available. Conversely, a value of 100 will mean that all data will
need to be present for the average to be calculated, else it is recorded as
\code{NA}. Not used if \code{avg.time = "default"}.}
    \item{\code{statistic}}{The statistic to apply when aggregating the data; default is
the mean. Can be one of "mean", "max", "min", "median", "frequency", "sd",
"percentile". Note that "sd" is the standard deviation and "frequency" is
the number (frequency) of valid records in the period. "percentile" is the
percentile level (\\%) between 0-100, which can be set using the
"percentile" option - see below. Not used if \code{avg.time = "default"}.}
    \item{\code{percentile}}{The percentile level in percent used when \code{statistic = "percentile"} and when aggregating the data with \code{avg.time}. The
default is 95. Not used if \code{avg.time = "default"}.}
    \item{\code{type}}{\code{type} determines how the data are split i.e. conditioned,
and then plotted. The default is will produce a single plot using the
entire data. Type can be one of the built-in types as detailed in
\code{cutData} e.g. \dQuote{season}, \dQuote{year}, \dQuote{weekday} and so
on. For example, \code{type = "season"} will produce four plots --- one for
each season.

It is also possible to choose \code{type} as another variable in the data
frame. If that variable is numeric, then the data will be split into four
quantiles (if possible) and labelled accordingly. If type is an existing
character or factor variable, then those categories/levels will be used
directly. This offers great flexibility for understanding the variation of
different variables and how they depend on one another.

Type can be up length two e.g. \code{type = c("season", "weekday")} will
produce a 2x2 plot split by season and day of the week. Note, when two
types are provided the first forms the columns and the second the rows.}
    \item{\code{smooth}}{A smooth line is fitted to the data if \code{TRUE}; optionally
with 95 percent confidence intervals shown. For \code{method = "level"} a
smooth surface will be fitted to binned data.}
    \item{\code{spline}}{A smooth spline is fitted to the data if \code{TRUE}. This is
particularly useful when there are fewer data points or when a connection
line between a sequence of points is required.}
    \item{\code{linear}}{A linear model is fitted to the data if \code{TRUE}; optionally
with 95 percent confidence intervals shown. The equation of the line and R2
value is also shown.}
    \item{\code{ci}}{Should the confidence intervals for the smooth/linear fit be shown?}
    \item{\code{mod.line}}{If \code{TRUE} three lines are added to the scatter plot to
help inform model evaluation. The 1:1 line is solid and the 1:0.5 and 1:2
lines are dashed. Together these lines help show how close a group of
points are to a 1:1 relationship and also show the points that are within a
factor of two (FAC2). \code{mod.line} is appropriately transformed when x
or y axes are on a log scale.}
    \item{\code{cols}}{Colours to be used for plotting. Options include
\dQuote{default}, \dQuote{increment}, \dQuote{heat}, \dQuote{jet} and
\code{RColorBrewer} colours --- see the \code{openair} \code{openColours}
function for more details. For user defined the user can supply a list of
colour names recognised by R (type \code{colours()} to see the full list).
An example would be \code{cols = c("yellow", "green", "blue")}}
    \item{\code{plot.type}}{\code{lattice} plot type. Can be \dQuote{p} (points ---
default), \dQuote{l} (lines) or \dQuote{b} (lines and points).}
    \item{\code{key}}{Should a key be drawn? The default is \code{TRUE}.}
    \item{\code{key.title}}{The title of the key (if used).}
    \item{\code{key.columns}}{Number of columns to be used in the key. With many
pollutants a single column can make to key too wide. The user can thus
choose to use several columns by setting \code{columns} to be less than the
number of pollutants.}
    \item{\code{key.position}}{Location where the scale key is to plotted.  Allowed
arguments currently include \dQuote{top}, \dQuote{right}, \dQuote{bottom}
and \dQuote{left}.}
    \item{\code{strip}}{Should a strip be drawn? The default is \code{TRUE}.}
    \item{\code{log.x}}{Should the x-axis appear on a log scale? The default is
\code{FALSE}. If \code{TRUE} a well-formatted log10 scale is used. This can
be useful for checking linearity once logged.}
    \item{\code{log.y}}{Should the y-axis appear on a log scale? The default is
\code{FALSE}. If \code{TRUE} a well-formatted log10 scale is used. This can
be useful for checking linearity once logged.}
    \item{\code{x.inc}}{The x-interval to be used for binning data when \code{method = "level"}.}
    \item{\code{y.inc}}{The y-interval to be used for binning data when \code{method = "level"}.}
    \item{\code{limits}}{For \code{method = "level"} the function does its best to
choose sensible limits automatically. However, there are circumstances when
the user will wish to set different ones. The limits are set in the form
\code{c(lower, upper)}, so \code{limits = c(0, 100)} would force the plot
limits to span 0-100.}
    \item{\code{windflow}}{This option allows a scatter plot to show the wind
speed/direction shows as an arrow. The option is a list e.g. \code{windflow = list(col = "grey", lwd = 2, scale = 0.1)}. This option requires wind
speed (\code{ws}) and wind direction (\code{wd}) to be available.

The maximum length of the arrow plotted is a fraction of the plot dimension
with the longest arrow being \code{scale} of the plot x-y dimension. Note,
if the plot size is adjusted manually by the user it should be re-plotted
to ensure the correct wind angle. The list may contain other options to
\code{panel.arrows} in the \code{lattice} package. Other useful options
include \code{length}, which controls the length of the arrow head and
\code{angle}, which controls the angle of the arrow head.

This option works best where there are not too many data to ensure
over-plotting does not become a problem.}
    \item{\code{y.relation}}{This determines how the y-axis scale is plotted.
\dQuote{same} ensures all panels use the same scale and \dQuote{free} will
use panel-specific scales. The latter is a useful setting when plotting
data with very different values.}
    \item{\code{x.relation}}{This determines how the x-axis scale is plotted.
\dQuote{same} ensures all panels use the same scale and \dQuote{free} will
use panel-specific scales. The latter is a useful setting when plotting
data with very different values.}
    \item{\code{ref.x}}{See \code{ref.y} for details.}
    \item{\code{ref.y}}{A list with details of the horizontal lines to be added
representing reference line(s). For example, \code{ref.y = list(h = 50, lty = 5)} will add a dashed horizontal line at 50. Several lines can be plotted
e.g. \code{ref.y = list(h = c(50, 100), lty = c(1, 5), col = c("green", "blue"))}. See \code{panel.abline} in the \code{lattice} package for more
details on adding/controlling lines.}
    \item{\code{k}}{Smoothing parameter supplied to \code{gam} for fitting a smooth
surface when \code{method = "level"}.}
    \item{\code{dist}}{When plotting smooth surfaces (\code{method = "level"} and
\code{smooth = TRUE}, \code{dist} controls how far from the original data
the predictions should be made. See \code{exclude.too.far} from the
\code{mgcv} package. Data are first transformed to a unit square. Values
should be between 0 and 1.}
    \item{\code{map}}{Should a base map be drawn? This option is under development.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly e.g.  by subscripting the \sQuote{2} in NO2.}
    \item{\code{plot}}{Should a plot be produced? \code{FALSE} can be useful when
analysing data to extract plot components and plotting them in other ways.}
  }}
}
\value{
an \link[=openair-package]{openair} object
}
\description{
Given hourly NOX and NO2 from a roadside site and hourly NOX, NO2 and O3 from
a background site the function will estimate the emissions ratio of NO2/NOX
--- the level of primary NO2
}
\details{
The principal purpose of this function is to estimate the level of primary
(or direct) NO2 from road vehicles. When hourly data of NOX, NO2 and O3 are
available, the total oxidant method of Clapp and Jenkin (2001) can be used.
If roadside O3 measurements are available see \code{\link[=linearRelation]{linearRelation()}} for details
of how to estimate the primary NO2 fraction.

In the absence of roadside O3 measurements, it is rather more problematic to
calculate the fraction of primary NO2. Carslaw and Beevers (2005c) developed
an approach based on \code{\link[=linearRelation]{linearRelation()}} the analysis of roadside and
background measurements. The increment in roadside NO2 concentrations is
primarily determined by direct emissions of NO2 and the availability of One
to react with NO to form NO2. The method aims to quantify the amount of NO2
formed through these two processes by seeking the optimum level of primary
NO2 that gives the least error.
}
\references{
Clapp, L.J., Jenkin, M.E., 2001. Analysis of the relationship
between ambient levels of O3, NO2 and NO as a function of NOX in the UK.
Atmospheric Environment 35 (36), 6391-6405.

Carslaw, D.C. and N Carslaw (2007).  Detecting and characterising small
changes in urban nitrogen dioxide concentrations.  Atmospheric Environment.
Vol. 41, 4723-4733.

Carslaw, D.C., Beevers, S.D. and M.C. Bell (2007). Risks of exceeding the
hourly EU limit value for nitrogen dioxide resulting from increased road
transport emissions of primary nitrogen dioxide. Atmospheric Environment 41
2073-2082.

Carslaw, D.C. (2005a). Evidence of an increasing NO2/NOX emissions ratio
from road traffic emissions. Atmospheric Environment, 39(26) 4793-4802.

Carslaw, D.C. and Beevers, S.D. (2005b). Development of an urban inventory
for road transport emissions of NO2 and comparison with estimates derived
from ambient measurements. Atmospheric Environment, (39): 2049-2059.

Carslaw, D.C. and Beevers, S.D. (2005c). Estimations of road vehicle
primary NO2 exhaust emission fractions using monitoring data in London.
Atmospheric Environment, 39(1): 167-177.

Carslaw, D. C. and S. D. Beevers (2004). Investigating the Potential
Importance of Primary NO2 Emissions in a Street Canyon. Atmospheric
Environment 38(22): 3585-3594.

Carslaw, D. C. and S. D. Beevers (2004). New Directions: Should road
vehicle emissions legislation consider primary NO2? Atmospheric Environment
38(8): 1233-1234.
}
\seealso{
\code{\link[=linearRelation]{linearRelation()}} if you have roadside ozone
measurements.
}
\author{
David Carslaw
}
