% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_reverse.R
\name{oc_reverse}
\alias{oc_reverse}
\title{Reverse geocoding}
\usage{
oc_reverse(
  latitude,
  longitude,
  return = c("df_list", "json_list", "geojson_list", "url_only"),
  language = NULL,
  min_confidence = NULL,
  no_annotations = TRUE,
  roadinfo = FALSE,
  no_dedupe = FALSE,
  abbrv = FALSE,
  add_request = FALSE,
  ...
)
}
\arguments{
\item{latitude, longitude}{Numeric vectors of latitude and longitude values.}

\item{return}{A character vector of length one indicating the return value of
the function, either a list of tibbles (\code{df_list}, the default), a JSON
list (\code{json_list}), a GeoJSON list (\code{geojson_list}), or the URL with which
the API would be called (\code{url_only}).}

\item{language}{An \href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47 language tag} (such as "es" for
Spanish or "pt-BR" for Brazilian Portuguese). OpenCage will attempt to
return results in that language. Alternatively you can specify the "native"
tag, in which case OpenCage will attempt to return the response in the
"official" language(s). In case the \code{language} parameter is set to \code{NULL}
(which is the default), the tag is not recognized, or OpenCage does not
have a record in that language, the results will be returned in English.}

\item{min_confidence}{Numeric vector of integer values between 0 and 10
indicating the precision of the returned result as defined by its
geographical extent, (i.e. by the extent of the result's bounding box). See
the \href{https://opencagedata.com/api#confidence}{API documentation} for
details. Only results with at least the requested confidence will be
returned. Default is \code{NULL}.}

\item{no_annotations}{Logical vector indicating whether additional
information about the result location should be returned. \code{TRUE} by
default, which means that the results will not contain annotations.}

\item{roadinfo}{Logical vector indicating whether the geocoder should attempt
to match the nearest road (rather than an address) and provide additional
road and driving information. Default is \code{FALSE}.}

\item{no_dedupe}{Logical vector (default \code{FALSE}), when \code{TRUE} the results
will not be deduplicated.}

\item{abbrv}{Logical vector (default \code{FALSE}), when \code{TRUE} addresses in the
\code{formatted} field of the results are abbreviated (e.g. "Main St." instead
of "Main Street").}

\item{add_request}{Logical vector (default \code{FALSE}) indicating whether the
request is returned again with the results. If the \code{return} value is a
\code{df_list}, the query text is added as a column to the results. \code{json_list}
results will contain all request parameters, including the API key used!
This is currently ignored by OpenCage if return value is \code{geojson_list}.}

\item{...}{Ignored.}
}
\value{
Depending on the \code{return} argument, \code{oc_reverse} returns a list with
either
\itemize{
\item the results as tibbles (\code{"df_list"}, the default),
\item the results as JSON specified as a list (\code{"json_list"}),
\item the results as GeoJSON specified as a list (\code{"geojson_list"}),
or
\item the URL of the OpenCage API call for debugging purposes
(\code{"url_only"}).
}

When the results are returned as (a list of) tibbles, the column names
coming from the OpenCage API are prefixed with \code{"oc_"}.
}
\description{
Reverse geocoding from numeric vectors of latitude and longitude pairs to
the names and addresses of a location.
}
\examples{
\dontshow{if (oc_key_present() && oc_api_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Reverse geocode a single location
oc_reverse(latitude = -36.85007, longitude = 174.7706)

# Reverse geocode multiple locations
lat <- c(47.21864, 53.55034, 34.05369)
lng <- c(-1.554136, 10.000654, -118.242767)

oc_reverse(latitude = lat, longitude = lng)

# Return results in a preferred language if possible
oc_reverse(latitude = lat, longitude = lng,
           language = "fr")

# Return results as a json list
oc_reverse(latitude = lat, longitude = lng,
           return = "json_list")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=oc_reverse_df]{oc_reverse_df()}} for inputs as a data frame, or \code{\link[=oc_forward]{oc_forward()}} and
\code{\link[=oc_forward]{oc_forward()}} for forward geocoding. For more information about the API
and the various parameters, see the \href{https://opencagedata.com/api}{OpenCage API documentation}.
}
