% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goodman_association.R
\name{Goodman_model_i}
\alias{Goodman_model_i}
\title{Fits Goodman's (1979) Model I}
\usage{
Goodman_model_i(
  n,
  row_effects = TRUE,
  column_effects = TRUE,
  max_iter = 25,
  verbose = FALSE,
  exclude_diagonal = FALSE
)
}
\arguments{
\item{n}{matrix of observed counts}

\item{row_effects}{should row effects be included in the model? Default is TRUE}

\item{column_effects}{should column effects be included in the model? Default is TRUE}

\item{max_iter}{maximum number of iterations. Default is 10}

\item{verbose}{logical. Should cycle-by-cycle output be printed? Default is no}

\item{exclude_diagonal}{logical. For square tables, should the cells on the
diagonal be excluded?  Default is FALSE, include all cells}
}
\value{
a list containing
   alpha: row effects
   beta: column effects
   gamma: row location weights
   delta: column location weights
   log_likelihood: log(likelihood)
   g_squared: G^2 fit measure
   chisq: X^2 fit measure
   df: degrees of freedom
}
\description{
Fits Goodman's (1979) Model I
}
