% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_project.R
\name{initialize_project}
\alias{initialize_project}
\title{Initialize project environment and structure}
\usage{
initialize_project(
  env = new.env(),
  home = NULL,
  results = NULL,
  folders_to_be_sourced = "R",
  source_folders_absolute = FALSE,
  encode_from = "UTF-8",
  encode_to = "latin1",
  ...
)
}
\arguments{
\item{env}{The environment that the code will be sourced into. Use \code{.GlobalEnv} to source code
into the global environment. If a different environment is provided, all functions will
be sourced into that environment.}

\item{home}{The folder containing 'Run.R' and 'R/'. This is the main project directory.}

\item{results}{The base folder for storing results. A subfolder with today's date will be created
and accessible via \code{org::project$results_today}.}

\item{folders_to_be_sourced}{Character vector of folder names inside \code{home} containing .R files
to be sourced into the environment.}

\item{source_folders_absolute}{If \code{TRUE}, \code{folders_to_be_sourced} is treated as absolute paths.
If \code{FALSE}, paths are relative to \code{home}.}

\item{encode_from}{Source encoding for file paths (only used on Windows)}

\item{encode_to}{Target encoding for file paths (only used on Windows)}

\item{...}{Additional named arguments for other project folders (e.g., data, raw, etc.)}
}
\value{
An environment containing:
\itemize{
\item All folder locations as named elements
\item \verb{$env}: The environment where code was sourced
\item \verb{$results_today}: Path to today's results folder
}
}
\description{
This function initializes a new R project by setting up folder locations and sourcing code files.
It creates a standardized project structure with separate locations for code, results, and data.
Results are automatically organized by date, and code can be sourced from specified directories.
}
\details{
The function performs several key operations:
\enumerate{
\item Creates necessary directories if they don't exist
\item Sets up date-based results organization
\item Sources all .R files from specified directories
\item Handles path encoding for cross-platform compatibility
\item Maintains a mirror of settings in \code{org::project}
}
}
\examples{
\dontrun{
# Initialize a new project
org::initialize_project(
  home = paste0(tempdir(), "/git/analyses/2019/analysis3/"),
  results = paste0(tempdir(), "/dropbox/analyses_results/2019/analysis3/"),
  raw = paste0(tempdir(), "/data/analyses/2019/analysis3/")
)

# Access project settings
org::project$results_today  # Today's results folder
org::project$raw           # Raw data folder
}
}
